/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment;

import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.osgi.deployment.ModuleRegistry;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;
import org.apache.axis2.osgi.deployment.OSGiServerConfigurator;
import org.apache.axis2.osgi.deployment.ServiceRegistry;
import org.apache.axis2.osgi.deployment.tracker.BundleTracker;
import org.apache.axis2.osgi.deployment.tracker.WSTracker;
import org.apache.axis2.osgi.tx.HttpListener;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class OSGiConfigurationContextFactory
implements ManagedService {
    private static Log log = LogFactory.getLog(OSGiConfigurationContextFactory.class);
    private BundleContext context;
    private ServiceRegistration mngServiceRegistration;
    private ServiceRegistration transportServiceRegistration;
    private ConfigurationContext configCtx;
    private ServiceRegistration configCtxServiceRegistration;
    private BundleTracker bundleTracker;

    public synchronized void start(BundleContext context) {
        this.context = context;
        this.bundleTracker = new BundleTracker(context);
        Properties props = new Properties();
        ((Dictionary)props).put("service.pid", "org.apache.axis2.osgi");
        this.mngServiceRegistration = context.registerService(ManagedService.class.getName(), (Object)this, (Dictionary)props);
    }

    public synchronized void stop() {
        if (this.configCtxServiceRegistration != null) {
            this.configCtxServiceRegistration.unregister();
        }
        if (this.transportServiceRegistration != null) {
            this.transportServiceRegistration.unregister();
        }
        if (this.mngServiceRegistration != null) {
            this.mngServiceRegistration.unregister();
        }
        this.bundleTracker.close();
        if (this.configCtx != null) {
            try {
                this.configCtx.terminate();
                this.configCtx = null;
            }
            catch (AxisFault e) {
                String msg = "Error while ConfigurationContext is terminated";
                log.error((Object)msg, (Throwable)e);
            }
        }
        log.info((Object)"Axis2 environment has stopped");
    }

    public synchronized void startConfigurationContext(Dictionary dictionary) throws AxisFault {
        OSGiServerConfigurator configurator = new OSGiServerConfigurator(this.context);
        this.configCtx = ConfigurationContextFactory.createConfigurationContext(configurator);
        ListenerManager listenerManager = new ListenerManager();
        listenerManager.init(this.configCtx);
        listenerManager.start();
    }

    public void updated(Dictionary dictionary) throws ConfigurationException {
        try {
            this.startConfigurationContext(dictionary);
            if (this.configCtxServiceRegistration != null) {
                this.configCtxServiceRegistration.unregister();
            }
            this.configCtxServiceRegistration = this.context.registerService(ConfigurationContext.class.getName(), (Object)this.configCtx, null);
            ServiceRegistry servicesRegistry = new ServiceRegistry(this.context, this.configCtx);
            ModuleRegistry moduleRegistry = new ModuleRegistry(this.context, this.configCtx, servicesRegistry);
            this.bundleTracker.addRegistry(servicesRegistry);
            this.bundleTracker.addRegistry(moduleRegistry);
            this.bundleTracker.open();
            new WSTracker(this.configCtx, this.context).open();
            this.context.addServiceListener((ServiceListener)new AxisConfigServiceListener(this.configCtx, this.context));
            Properties prop = new Properties();
            ((Dictionary)prop).put(OSGiAxis2Constants.PROTOCOL, "http");
            this.transportServiceRegistration = this.context.registerService(TransportListener.class.getName(), (Object)new HttpListener(this.context), (Dictionary)prop);
            log.info((Object)"Axis2 environment has started.");
        }
        catch (AxisFault e) {
            String msg = "Error while creating ConfigurationContext";
            log.error((Object)msg, (Throwable)e);
            throw new ConfigurationException(msg, msg, (Throwable)e);
        }
    }

    private static class AxisConfigServiceListener
    implements ServiceListener {
        private ConfigurationContext configCtx;
        private AxisConfiguration axisConfig;
        private BundleContext context;
        private Lock lock = new ReentrantLock();

        public AxisConfigServiceListener(ConfigurationContext configCtx, BundleContext context) {
            this.configCtx = configCtx;
            this.context = context;
            this.axisConfig = configCtx.getAxisConfiguration();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            ServiceReference reference = event.getServiceReference();
            Object service = this.context.getService(reference);
            if (service instanceof TransportListener) {
                String protocol = (String)reference.getProperty(OSGiAxis2Constants.PROTOCOL);
                if (protocol == null || protocol.length() == 0) {
                    String msg = "Protocol is not found for the trnasport object";
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
                if (event.getType() == 1) {
                    TransportListener txListener = (TransportListener)service;
                    TransportInDescription txInDes = new TransportInDescription(protocol);
                    txInDes.setReceiver(txListener);
                    String[] keys = reference.getPropertyKeys();
                    if (keys != null) {
                        for (String key : keys) {
                            if (key.equals(OSGiAxis2Constants.PROTOCOL)) continue;
                            try {
                                Object propObj = reference.getProperty(key);
                                if (!(propObj instanceof String)) continue;
                                String value = (String)propObj;
                                Parameter param = new Parameter(key, value);
                                txInDes.addParameter(param);
                            }
                            catch (AxisFault e) {
                                String msg = "Error while reading transport properties from :" + txListener.toString();
                                log.error((Object)msg, (Throwable)e);
                                throw new RuntimeException(msg, e);
                            }
                        }
                    }
                    try {
                        this.configCtx.getListenerManager().addListener(txInDes, false);
                        this.lock.lock();
                        try {
                            for (String serviceName : this.axisConfig.getServices().keySet()) {
                                AxisService axisService = this.axisConfig.getService(serviceName);
                                Utils.addEndpointsToService(axisService, this.axisConfig);
                            }
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                    catch (AxisFault e) {
                        String msg = "Error while intiating and starting the listener";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            } else if (service instanceof Builder) {
                String contextType = (String)reference.getProperty(OSGiAxis2Constants.CONTENT_TYPE);
                if (contextType == null || contextType.length() == 0) {
                    String msg = OSGiAxis2Constants.CONTENT_TYPE + " is missing from builder object";
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
                if (event.getType() == 1 || event.getType() == 2) {
                    Builder builder = (Builder)service;
                    this.lock.lock();
                    try {
                        this.axisConfig.addMessageBuilder(contextType, builder);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            } else if (service instanceof MessageFormatter) {
                String contextType = (String)reference.getProperty(OSGiAxis2Constants.CONTENT_TYPE);
                if (contextType == null || contextType.length() == 0) {
                    String msg = OSGiAxis2Constants.CONTENT_TYPE + " is missing from formatter object";
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
                if (event.getType() == 1 || event.getType() == 2) {
                    MessageFormatter formatter = (MessageFormatter)service;
                    this.lock.lock();
                    try {
                        this.axisConfig.addMessageFormatter(contextType, formatter);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            } else if (service instanceof MessageReceiver) {
                String mep = (String)reference.getProperty(OSGiAxis2Constants.MEP);
                if (mep == null || mep.length() == 0) {
                    String msg = OSGiAxis2Constants.MEP + " is missing from message receiver object";
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
                if (event.getType() == 1 || event.getType() == 2) {
                    MessageReceiver mr = (MessageReceiver)service;
                    this.lock.lock();
                    try {
                        this.axisConfig.addMessageReceiver(mep, mr);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            } else if (service instanceof AxisObserver) {
                if (event.getType() == 1 || event.getType() == 2) {
                    AxisObserver axisObserver = (AxisObserver)service;
                    this.lock.lock();
                    try {
                        axisObserver.init(this.axisConfig);
                        this.axisConfig.addObservers(axisObserver);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            } else if (service instanceof TransportSender || service instanceof Deployer) {
                // empty if block
            }
        }
    }
}

