/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxbri;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.Property;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CodeGenerationUtility {
    private static final Log log = LogFactory.getLog(CodeGenerationUtility.class);
    public static final String BINDING_FILE_NAME = "bindingFileName";

    public static TypeMapper processSchemas(List schemas, Element[] additionalSchemas, CodeGenConfiguration cgconfig) throws RuntimeException {
        try {
            if (schemas == null || schemas.isEmpty()) {
                return new DefaultTypeMapper();
            }
            final HashMap<XmlSchema, InputSource> schemaToInputSourceMap = new HashMap<XmlSchema, InputSource>();
            final HashMap publicIDToStringMap = new HashMap();
            JavaTypeMapper mapper = new JavaTypeMapper();
            String baseURI = cgconfig.getBaseURI();
            if (!baseURI.endsWith("/")) {
                baseURI = baseURI + "/";
            }
            for (int i = 0; i < schemas.size(); ++i) {
                XmlSchema schema = (XmlSchema)schemas.get(i);
                InputSource inputSource = new InputSource(new StringReader(CodeGenerationUtility.getSchemaAsString(schema)));
                inputSource.setSystemId(baseURI + "xsd" + i + ".xsd");
                inputSource.setPublicId(schema.getTargetNamespace());
                schemaToInputSourceMap.put(schema, inputSource);
            }
            File outputDir = new File(cgconfig.getOutputLocation(), "src");
            outputDir.mkdir();
            Map nsMap = cgconfig.getUri2PackageNameMap();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource returnInputSource = null;
                    XmlSchema key2 = null;
                    for (XmlSchema key2 : schemaToInputSourceMap.keySet()) {
                        String nsp = key2.getTargetNamespace();
                        if (nsp == null || !nsp.equals(publicId)) continue;
                        returnInputSource = new InputSource(new StringReader(CodeGenerationUtility.getSchemaAsString(key2)));
                        InputSource existingInputSource = (InputSource)schemaToInputSourceMap.get(key2);
                        returnInputSource.setSystemId(existingInputSource.getSystemId());
                        returnInputSource.setPublicId(existingInputSource.getPublicId());
                        break;
                    }
                    if (returnInputSource == null && systemId != null) {
                        returnInputSource = new InputSource(systemId);
                        returnInputSource.setSystemId(systemId);
                    }
                    if (returnInputSource == null && publicId != null) {
                        if (!publicIDToStringMap.containsKey(publicId)) {
                            URL url = new URL(publicId);
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                            StringBuffer stringBuffer = new StringBuffer();
                            String str = null;
                            while ((str = bufferedReader.readLine()) != null) {
                                stringBuffer.append(str);
                            }
                            bufferedReader.close();
                            publicIDToStringMap.put(publicId, stringBuffer);
                        }
                        String schemaString = ((StringBuffer)publicIDToStringMap.get(publicId)).toString();
                        returnInputSource = new InputSource(new StringReader(schemaString));
                        returnInputSource.setPublicId(publicId);
                        returnInputSource.setSystemId(publicId);
                    }
                    return returnInputSource;
                }
            };
            Map properties = cgconfig.getProperties();
            String bindingFileName = (String)properties.get(BINDING_FILE_NAME);
            XmlSchema key = null;
            Iterator schemaIter = schemaToInputSourceMap.keySet().iterator();
            while (schemaIter.hasNext()) {
                SchemaCompiler sc = XJC.createSchemaCompiler();
                if (bindingFileName != null) {
                    if (bindingFileName.endsWith(".jar")) {
                        CodeGenerationUtility.scanEpisodeFile(new File(bindingFileName), sc);
                    } else {
                        InputSource inputSoruce = new InputSource(new FileInputStream(bindingFileName));
                        inputSoruce.setSystemId(new File(bindingFileName).toURI().toString());
                        sc.getOptions().addBindFile(inputSoruce);
                    }
                }
                key = (XmlSchema)schemaIter.next();
                if (nsMap != null) {
                    for (Map.Entry entry : nsMap.entrySet()) {
                        String namespace = (String)entry.getKey();
                        String pkg = (String)nsMap.get(namespace);
                        CodeGenerationUtility.registerNamespace(sc, namespace, pkg);
                    }
                }
                sc.setEntityResolver(resolver);
                sc.setErrorListener(new ErrorListener(){

                    public void error(SAXParseException saxParseException) {
                        log.error((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }

                    public void fatalError(SAXParseException saxParseException) {
                        log.error((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }

                    public void warning(SAXParseException saxParseException) {
                        log.warn((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }

                    public void info(SAXParseException saxParseException) {
                        log.info((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }
                });
                sc.parseSchema((InputSource)schemaToInputSourceMap.get(key));
                sc.getOptions().addGrammar((InputSource)schemaToInputSourceMap.get(key));
                for (Object property : properties.keySet()) {
                    String propertyName = (String)property;
                    if (!propertyName.startsWith("X")) continue;
                    String[] args = null;
                    String propertyValue = (String)properties.get(property);
                    args = propertyValue != null ? new String[]{"-" + propertyName, propertyValue} : new String[]{"-" + propertyName};
                    sc.getOptions().parseArguments(args);
                }
                S2JJAXBModel jaxbModel = sc.bind();
                if (jaxbModel == null) {
                    throw new RuntimeException("Unable to generate code using jaxbri");
                }
                JCodeModel codeModel = jaxbModel.generateCode(null, null);
                FileCodeWriter writer = new FileCodeWriter(outputDir);
                codeModel.build((CodeWriter)writer);
                Collection mappings = jaxbModel.getMappings();
                for (Mapping mapping : mappings) {
                    QName qn = mapping.getElement();
                    String typeName = mapping.getType().getTypeClass().fullName();
                    mapper.addTypeMappingName(qn, typeName);
                }
                if (cgconfig.isParametersWrapped()) continue;
                List axisServices = cgconfig.getAxisServices();
                for (AxisService axisService : axisServices) {
                    Iterator operations = axisService.getOperations();
                    while (operations.hasNext()) {
                        String fullJaveName;
                        QName partQName;
                        Property elementProperty;
                        int j;
                        List elementProperties;
                        Mapping mapping;
                        AxisMessage message;
                        AxisOperation op = (AxisOperation)operations.next();
                        if (WSDLUtil.isInputPresentForMEP((String)op.getMessageExchangePattern()) && (message = op.getMessage("In")) != null && message.getParameter("UnWrapped") != null) {
                            mapping = jaxbModel.get(message.getElementQName());
                            elementProperties = mapping.getWrapperStyleDrilldown();
                            for (j = 0; j < elementProperties.size(); ++j) {
                                elementProperty = (Property)elementProperties.get(j);
                                partQName = WSDLUtil.getPartQName((String)op.getName().getLocalPart(), (String)"_input", (String)elementProperty.elementName().getLocalPart());
                                fullJaveName = elementProperty.type().fullName();
                                if (elementProperty.type().isArray()) {
                                    fullJaveName = fullJaveName.concat("[]");
                                }
                                mapper.addTypeMappingName(partQName, fullJaveName);
                                if (elementProperty.type().isPrimitive()) {
                                    mapper.addTypeMappingStatus(partQName, (Object)Boolean.TRUE);
                                }
                                if (!elementProperty.type().isArray()) continue;
                                mapper.addTypeMappingStatus(partQName, (Object)"arrayType");
                            }
                        }
                        if (!WSDLUtil.isOutputPresentForMEP((String)op.getMessageExchangePattern()) || (message = op.getMessage("Out")) == null || message.getParameter("UnWrapped") == null) continue;
                        mapping = jaxbModel.get(message.getElementQName());
                        elementProperties = mapping.getWrapperStyleDrilldown();
                        for (j = 0; j < elementProperties.size(); ++j) {
                            elementProperty = (Property)elementProperties.get(j);
                            partQName = WSDLUtil.getPartQName((String)op.getName().getLocalPart(), (String)"_output", (String)elementProperty.elementName().getLocalPart());
                            fullJaveName = elementProperty.type().fullName();
                            if (elementProperty.type().isArray()) {
                                fullJaveName = fullJaveName.concat("[]");
                            }
                            mapper.addTypeMappingName(partQName, fullJaveName);
                            if (elementProperty.type().isPrimitive()) {
                                mapper.addTypeMappingStatus(partQName, (Object)Boolean.TRUE);
                            }
                            if (!elementProperty.type().isArray()) continue;
                            mapper.addTypeMappingStatus(partQName, (Object)"arrayType");
                        }
                    }
                }
            }
            return mapper;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void scanEpisodeFile(File jar, SchemaCompiler sc) throws BadCommandLineException, IOException {
        URLClassLoader ucl = new URLClassLoader(new URL[]{jar.toURL()});
        Enumeration<URL> resources = ucl.findResources("META-INF/sun-jaxb.episode");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            sc.getOptions().addBindFile(new InputSource(url.toExternalForm()));
        }
    }

    private static void registerNamespace(SchemaCompiler sc, String namespace, String pkgName) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element rootElement = doc.createElement("schema");
        rootElement.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        rootElement.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
        rootElement.setAttribute("jaxb:version", "2.0");
        rootElement.setAttribute("targetNamespace", namespace);
        Element annoElement = doc.createElement("annotation");
        Element appInfo = doc.createElement("appinfo");
        Element schemaBindings = doc.createElement("jaxb:schemaBindings");
        Element pkgElement = doc.createElement("jaxb:package");
        pkgElement.setAttribute("name", pkgName);
        annoElement.appendChild(appInfo);
        appInfo.appendChild(schemaBindings);
        schemaBindings.appendChild(pkgElement);
        rootElement.appendChild(annoElement);
        File file = File.createTempFile("customized", ".xsd");
        FileOutputStream stream = new FileOutputStream(file);
        try {
            StreamResult result = new StreamResult(stream);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(rootElement), result);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputSource ins = new InputSource(file.toURI().toString());
        sc.parseSchema(ins);
        file.delete();
    }

    private static String extractNamespace(XmlSchema schema) {
        String pkg = schema.getTargetNamespace();
        if (pkg == null) {
            XmlSchema[] schemas2 = SchemaUtil.getAllSchemas((XmlSchema)schema);
            for (int j = 0; schemas2 != null && j < schemas2.length && (pkg = schemas2[j].getTargetNamespace()) == null; ++j) {
            }
        }
        if (pkg == null) {
            pkg = "org.apache.axis2";
        }
        pkg = URLProcessor.makePackageName((String)pkg);
        return pkg;
    }

    private static String getSchemaAsString(XmlSchema schema) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schema.write((OutputStream)baos);
        return baos.toString();
    }
}

