/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkLauncher;
import org.apache.beam.sdk.nexmark.NexmarkOptions;
import org.apache.beam.sdk.nexmark.NexmarkPerf;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class Main<OptionT extends NexmarkOptions> {
    private static final String LINE = "==========================================================================================";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAll(OptionT options, NexmarkLauncher nexmarkLauncher) throws IOException {
        Instant start = Instant.now();
        Map<NexmarkConfiguration, NexmarkPerf> baseline = Main.loadBaseline(options.getBaselineFilename());
        LinkedHashMap<NexmarkConfiguration, NexmarkPerf> actual = new LinkedHashMap<NexmarkConfiguration, NexmarkPerf>();
        Iterable<NexmarkConfiguration> configurations = options.getSuite().getConfigurations((NexmarkOptions)options);
        boolean successful = true;
        try {
            for (NexmarkConfiguration configuration : configurations) {
                NexmarkPerf perf = nexmarkLauncher.run(configuration);
                if (perf == null) continue;
                if (perf.errors == null || perf.errors.size() > 0) {
                    successful = false;
                }
                this.appendPerf(options.getPerfFilename(), configuration, perf);
                actual.put(configuration, perf);
                Main.saveSummary(null, configurations, actual, baseline, start, options);
            }
            if (options.getExportSummaryToBigQuery().booleanValue()) {
                Main.savePerfsToBigQuery(options, actual, null, start);
            }
        }
        finally {
            if (options.getMonitorJobs()) {
                Main.saveSummary(options.getSummaryFilename(), configurations, actual, baseline, start, options);
                Main.saveJavascript(options.getJavascriptFilename(), configurations, actual, baseline, start);
            }
        }
        if (!successful) {
            throw new RuntimeException("Execution was not successful");
        }
    }

    @VisibleForTesting
    static void savePerfsToBigQuery(NexmarkOptions options, Map<NexmarkConfiguration, NexmarkPerf> perfs, @Nullable BigQueryServices testBigQueryServices, Instant start) {
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection perfsPCollection = (PCollection)pipeline.apply((PTransform)Create.of(perfs).withCoder((Coder)KvCoder.of((Coder)SerializableCoder.of(NexmarkConfiguration.class), (Coder)new CustomCoder<NexmarkPerf>(){

            public void encode(NexmarkPerf value, OutputStream outStream) throws CoderException, IOException {
                StringUtf8Coder.of().encode(value.toString(), outStream);
            }

            public NexmarkPerf decode(InputStream inStream) throws CoderException, IOException {
                String perf = StringUtf8Coder.of().decode(inStream);
                return NexmarkPerf.fromString(perf);
            }
        })));
        TableSchema tableSchema = new TableSchema().setFields(ImmutableList.of(new TableFieldSchema().setName("timestamp").setType("TIMESTAMP"), new TableFieldSchema().setName("runtimeSec").setType("FLOAT"), new TableFieldSchema().setName("eventsPerSec").setType("FLOAT"), new TableFieldSchema().setName("numResults").setType("INTEGER")));
        String queryName = "{query}";
        if (options.getQueryLanguage() != null) {
            queryName = queryName + "_" + options.getQueryLanguage();
        }
        String tableSpec = NexmarkUtils.tableSpec(options, queryName, 0L, null);
        SerializableFunction & Serializable tableFunction = (SerializableFunction & Serializable)input -> new TableDestination(tableSpec.replace("{query}", String.valueOf(((NexmarkConfiguration)((KV)input.getValue()).getKey()).query)), "perfkit queries");
        SerializableFunction & Serializable rowFunction = (SerializableFunction & Serializable)input -> {
            NexmarkPerf nexmarkPerf = (NexmarkPerf)input.getValue();
            TableRow row = new TableRow().set("timestamp", (Object)(start.getMillis() / 1000L)).set("runtimeSec", (Object)nexmarkPerf.runtimeSec).set("eventsPerSec", (Object)nexmarkPerf.eventsPerSec).set("numResults", (Object)nexmarkPerf.numResults);
            return row;
        };
        BigQueryIO.Write io = BigQueryIO.write().to((SerializableFunction)tableFunction).withSchema(tableSchema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND).withFormatFunction((SerializableFunction)rowFunction);
        if (testBigQueryServices != null) {
            io = io.withTestServices(testBigQueryServices);
        }
        perfsPCollection.apply("savePerfsToBigQuery", (PTransform)io);
        pipeline.run();
    }

    private void appendPerf(@Nullable String perfFilename, NexmarkConfiguration configuration, NexmarkPerf perf) {
        if (perfFilename == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add(String.format("# %s", Instant.now()));
        lines.add(String.format("# %s", configuration.toShortString()));
        lines.add(configuration.toString());
        lines.add(perf.toString());
        try {
            Files.write(Paths.get(perfFilename, new String[0]), lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write perf file: ", e);
        }
        NexmarkUtils.console("appended results to perf file %s.", perfFilename);
    }

    @Nullable
    private static Map<NexmarkConfiguration, NexmarkPerf> loadBaseline(@Nullable String baselineFilename) {
        List<String> lines;
        if (baselineFilename == null) {
            return null;
        }
        LinkedHashMap<NexmarkConfiguration, NexmarkPerf> baseline = new LinkedHashMap<NexmarkConfiguration, NexmarkPerf>();
        try {
            lines = Files.readAllLines(Paths.get(baselineFilename, new String[0]), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read baseline perf file: ", e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            if (lines.get(i).startsWith("#") || lines.get(i).trim().isEmpty()) continue;
            NexmarkConfiguration configuration = NexmarkConfiguration.fromString(lines.get(i++));
            NexmarkPerf perf = NexmarkPerf.fromString(lines.get(i));
            baseline.put(configuration, perf);
        }
        NexmarkUtils.console("loaded %d entries from baseline file %s.", baseline.size(), baselineFilename);
        return baseline;
    }

    private static void saveSummary(@Nullable String summaryFilename, Iterable<NexmarkConfiguration> configurations, Map<NexmarkConfiguration, NexmarkPerf> actual, @Nullable Map<NexmarkConfiguration, NexmarkPerf> baseline, Instant start, NexmarkOptions options) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add(LINE);
        lines.add(String.format("Run started %s and ran for %s", start, new Duration((ReadableInstant)start, (ReadableInstant)Instant.now())));
        lines.add("");
        lines.add("Default configuration:");
        lines.add(NexmarkConfiguration.DEFAULT.toString());
        lines.add("");
        lines.add("Configurations:");
        lines.add("  Conf  Description");
        int conf = 0;
        for (NexmarkConfiguration configuration : configurations) {
            lines.add(String.format("  %04d  %s", conf++, configuration.toShortString()));
            NexmarkPerf actualPerf = actual.get(configuration);
            if (actualPerf == null || actualPerf.jobId == null) continue;
            lines.add(String.format("  %4s  [Ran as job %s]", "", actualPerf.jobId));
        }
        lines.add("");
        lines.add("Performance:");
        lines.add(String.format("  %4s  %12s  %12s  %12s  %12s  %12s  %12s", "Conf", "Runtime(sec)", "(Baseline)", "Events(/sec)", "(Baseline)", "Results", "(Baseline)"));
        conf = 0;
        for (NexmarkConfiguration configuration : configurations) {
            String line = String.format("  %04d  ", conf++);
            NexmarkPerf actualPerf = actual.get(configuration);
            if (actualPerf == null) {
                line = line + "*** not run ***";
            } else {
                NexmarkPerf baselinePerf = baseline == null ? null : baseline.get(configuration);
                double runtimeSec = actualPerf.runtimeSec;
                line = line + String.format("%12.1f  ", runtimeSec);
                if (baselinePerf == null) {
                    line = line + String.format("%12s  ", "");
                } else {
                    double baselineRuntimeSec = baselinePerf.runtimeSec;
                    double diff = (runtimeSec - baselineRuntimeSec) / baselineRuntimeSec * 100.0;
                    line = line + String.format("%+11.2f%%  ", diff);
                }
                double eventsPerSec = actualPerf.eventsPerSec;
                line = line + String.format("%12.1f  ", eventsPerSec);
                if (baselinePerf == null) {
                    line = line + String.format("%12s  ", "");
                } else {
                    double baselineEventsPerSec = baselinePerf.eventsPerSec;
                    double diff = (eventsPerSec - baselineEventsPerSec) / baselineEventsPerSec * 100.0;
                    line = line + String.format("%+11.2f%%  ", diff);
                }
                long numResults = actualPerf.numResults;
                line = line + String.format("%12d  ", numResults);
                if (baselinePerf == null) {
                    line = line + String.format("%12s", "");
                } else {
                    long baselineNumResults = baselinePerf.numResults;
                    long diff = numResults - baselineNumResults;
                    line = line + String.format("%+12d", diff);
                }
            }
            lines.add(line);
            if (actualPerf == null) continue;
            List<String> errors = actualPerf.errors;
            if (errors == null) {
                errors = new ArrayList<String>();
                errors.add("NexmarkGoogleRunner returned null errors list");
            }
            for (String error : errors) {
                lines.add(String.format("  %4s  *** %s ***", "", error));
            }
        }
        lines.add(LINE);
        lines.add("");
        for (String line : lines) {
            System.out.println(line);
        }
        if (summaryFilename != null) {
            try {
                Files.write(Paths.get(summaryFilename, new String[0]), lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to save summary file: ", e);
            }
            NexmarkUtils.console("appended summary to summary file %s.", summaryFilename);
        }
    }

    private static void saveJavascript(@Nullable String javascriptFilename, Iterable<NexmarkConfiguration> configurations, Map<NexmarkConfiguration, NexmarkPerf> actual, @Nullable Map<NexmarkConfiguration, NexmarkPerf> baseline, Instant start) {
        if (javascriptFilename == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("// Run started %s and ran for %s", start, new Duration((ReadableInstant)start, (ReadableInstant)Instant.now())));
        lines.add("var all = [");
        for (NexmarkConfiguration configuration : configurations) {
            NexmarkPerf baselinePerf;
            lines.add("  {");
            lines.add(String.format("    config: %s", configuration));
            NexmarkPerf actualPerf = actual.get(configuration);
            if (actualPerf != null) {
                lines.add(String.format("    ,perf: %s", actualPerf));
            }
            NexmarkPerf nexmarkPerf = baselinePerf = baseline == null ? null : baseline.get(configuration);
            if (baselinePerf != null) {
                lines.add(String.format("    ,baseline: %s", baselinePerf));
            }
            lines.add("  },");
        }
        lines.add("];");
        try {
            Files.write(Paths.get(javascriptFilename, new String[0]), lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save javascript file: ", e);
        }
        NexmarkUtils.console("saved javascript to file %s.", javascriptFilename);
    }

    public static void main(String[] args) throws IOException {
        NexmarkOptions options = (NexmarkOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(NexmarkOptions.class);
        NexmarkLauncher<NexmarkOptions> nexmarkLauncher = new NexmarkLauncher<NexmarkOptions>(options);
        new Main<NexmarkOptions>().runAll(options, nexmarkLauncher);
    }
}

