/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark;

import java.io.Serializable;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;

public class Monitor<T extends KnownSize>
implements Serializable {
    public final String name;
    public final String prefix;
    private final MonitorDoFn doFn;
    private final PTransform<PCollection<? extends T>, PCollection<T>> transform;

    public Monitor(String name, String prefix) {
        this.name = name;
        this.prefix = prefix;
        this.doFn = new MonitorDoFn();
        this.transform = ParDo.of((DoFn)this.doFn);
    }

    public PTransform<PCollection<? extends T>, PCollection<T>> getTransform() {
        return this.transform;
    }

    private class MonitorDoFn
    extends DoFn<T, T> {
        final Counter elementCounter;
        final Counter bytesCounter;
        final Distribution startTime;
        final Distribution endTime;
        final Distribution startTimestamp;
        final Distribution endTimestamp;

        private MonitorDoFn() {
            this.elementCounter = Metrics.counter((String)Monitor.this.name, (String)(Monitor.this.prefix + ".elements"));
            this.bytesCounter = Metrics.counter((String)Monitor.this.name, (String)(Monitor.this.prefix + ".bytes"));
            this.startTime = Metrics.distribution((String)Monitor.this.name, (String)(Monitor.this.prefix + ".startTime"));
            this.endTime = Metrics.distribution((String)Monitor.this.name, (String)(Monitor.this.prefix + ".endTime"));
            this.startTimestamp = Metrics.distribution((String)Monitor.this.name, (String)(Monitor.this.prefix + ".startTimestamp"));
            this.endTimestamp = Metrics.distribution((String)Monitor.this.name, (String)(Monitor.this.prefix + ".endTimestamp"));
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            this.elementCounter.inc();
            this.bytesCounter.inc(((KnownSize)c.element()).sizeInBytes());
            long now = System.currentTimeMillis();
            this.startTime.update(now);
            this.endTime.update(now);
            this.startTimestamp.update(c.timestamp().getMillis());
            this.endTimestamp.update(c.timestamp().getMillis());
            c.output((Object)((KnownSize)c.element()));
        }
    }
}

