/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.nexmark.NexmarkOptions;
import org.apache.beam.sdk.nexmark.NexmarkUtils;

public class NexmarkConfiguration
implements Serializable {
    public static final NexmarkConfiguration DEFAULT = new NexmarkConfiguration();
    @JsonProperty
    public boolean debug = true;
    @JsonProperty
    public int query = 0;
    @JsonProperty
    public NexmarkUtils.SourceType sourceType = NexmarkUtils.SourceType.DIRECT;
    @JsonProperty
    public NexmarkUtils.SinkType sinkType = NexmarkUtils.SinkType.DEVNULL;
    @JsonProperty
    public boolean exportSummaryToBigQuery = false;
    @JsonProperty
    public NexmarkUtils.PubSubMode pubSubMode = NexmarkUtils.PubSubMode.COMBINED;
    @JsonProperty
    public long numEvents = 100000L;
    @JsonProperty
    public int numEventGenerators = 100;
    @JsonProperty
    public NexmarkUtils.RateShape rateShape = NexmarkUtils.RateShape.SINE;
    @JsonProperty
    public int firstEventRate = 10000;
    @JsonProperty
    public int nextEventRate = 10000;
    @JsonProperty
    public NexmarkUtils.RateUnit rateUnit = NexmarkUtils.RateUnit.PER_SECOND;
    @JsonProperty
    public int ratePeriodSec = 600;
    @JsonProperty
    public int preloadSeconds = 0;
    @JsonProperty
    public int streamTimeout = 240;
    @JsonProperty
    public boolean isRateLimited = false;
    @JsonProperty
    public boolean useWallclockEventTime = false;
    @JsonProperty
    public int avgPersonByteSize = 200;
    @JsonProperty
    public int avgAuctionByteSize = 500;
    @JsonProperty
    public int avgBidByteSize = 100;
    @JsonProperty
    public int hotAuctionRatio = 2;
    @JsonProperty
    public int hotSellersRatio = 4;
    @JsonProperty
    public int hotBiddersRatio = 4;
    @JsonProperty
    public long windowSizeSec = 10L;
    @JsonProperty
    public long windowPeriodSec = 5L;
    @JsonProperty
    public long watermarkHoldbackSec = 0L;
    @JsonProperty
    public int numInFlightAuctions = 100;
    @JsonProperty
    public int numActivePeople = 1000;
    @JsonProperty
    public NexmarkUtils.CoderStrategy coderStrategy = NexmarkUtils.CoderStrategy.HAND;
    @JsonProperty
    public long cpuDelayMs = 0L;
    @JsonProperty
    public long diskBusyBytes = 0L;
    @JsonProperty
    public int auctionSkip = 123;
    @JsonProperty
    public int fanout = 5;
    @JsonProperty
    public int maxAuctionsWaitingTime = 600;
    @JsonProperty
    public long occasionalDelaySec = 3L;
    @JsonProperty
    public double probDelayedEvent = 0.1;
    @JsonProperty
    public int maxLogEvents = 100000;
    @JsonProperty
    public boolean usePubsubPublishTime = false;
    @JsonProperty
    public long outOfOrderGroupSize = 1L;

    public void overrideFromOptions(NexmarkOptions options) {
        if (options.getDebug() != null) {
            this.debug = options.getDebug();
        }
        if (options.getQuery() != null) {
            this.query = options.getQuery();
        }
        if (options.getSourceType() != null) {
            this.sourceType = options.getSourceType();
        }
        if (options.getSinkType() != null) {
            this.sinkType = options.getSinkType();
        }
        if (options.getExportSummaryToBigQuery() != null) {
            this.exportSummaryToBigQuery = options.getExportSummaryToBigQuery();
        }
        if (options.getPubSubMode() != null) {
            this.pubSubMode = options.getPubSubMode();
        }
        if (options.getNumEvents() != null) {
            this.numEvents = options.getNumEvents();
        }
        if (options.getNumEventGenerators() != null) {
            this.numEventGenerators = options.getNumEventGenerators();
        }
        if (options.getRateShape() != null) {
            this.rateShape = options.getRateShape();
        }
        if (options.getFirstEventRate() != null) {
            this.firstEventRate = options.getFirstEventRate();
        }
        if (options.getNextEventRate() != null) {
            this.nextEventRate = options.getNextEventRate();
        }
        if (options.getRateUnit() != null) {
            this.rateUnit = options.getRateUnit();
        }
        if (options.getRatePeriodSec() != null) {
            this.ratePeriodSec = options.getRatePeriodSec();
        }
        if (options.getPreloadSeconds() != null) {
            this.preloadSeconds = options.getPreloadSeconds();
        }
        if (options.getStreamTimeout() != null) {
            this.streamTimeout = options.getStreamTimeout();
        }
        if (options.getIsRateLimited() != null) {
            this.isRateLimited = options.getIsRateLimited();
        }
        if (options.getUseWallclockEventTime() != null) {
            this.useWallclockEventTime = options.getUseWallclockEventTime();
        }
        if (options.getAvgPersonByteSize() != null) {
            this.avgPersonByteSize = options.getAvgPersonByteSize();
        }
        if (options.getAvgAuctionByteSize() != null) {
            this.avgAuctionByteSize = options.getAvgAuctionByteSize();
        }
        if (options.getAvgBidByteSize() != null) {
            this.avgBidByteSize = options.getAvgBidByteSize();
        }
        if (options.getHotAuctionRatio() != null) {
            this.hotAuctionRatio = options.getHotAuctionRatio();
        }
        if (options.getHotSellersRatio() != null) {
            this.hotSellersRatio = options.getHotSellersRatio();
        }
        if (options.getHotBiddersRatio() != null) {
            this.hotBiddersRatio = options.getHotBiddersRatio();
        }
        if (options.getWindowSizeSec() != null) {
            this.windowSizeSec = options.getWindowSizeSec();
        }
        if (options.getWindowPeriodSec() != null) {
            this.windowPeriodSec = options.getWindowPeriodSec();
        }
        if (options.getWatermarkHoldbackSec() != null) {
            this.watermarkHoldbackSec = options.getWatermarkHoldbackSec();
        }
        if (options.getNumInFlightAuctions() != null) {
            this.numInFlightAuctions = options.getNumInFlightAuctions();
        }
        if (options.getNumActivePeople() != null) {
            this.numActivePeople = options.getNumActivePeople();
        }
        if (options.getCoderStrategy() != null) {
            this.coderStrategy = options.getCoderStrategy();
        }
        if (options.getCpuDelayMs() != null) {
            this.cpuDelayMs = options.getCpuDelayMs();
        }
        if (options.getDiskBusyBytes() != null) {
            this.diskBusyBytes = options.getDiskBusyBytes();
        }
        if (options.getAuctionSkip() != null) {
            this.auctionSkip = options.getAuctionSkip();
        }
        if (options.getFanout() != null) {
            this.fanout = options.getFanout();
        }
        if (options.getMaxAuctionsWaitingTime() != null) {
            this.fanout = options.getMaxAuctionsWaitingTime();
        }
        if (options.getOccasionalDelaySec() != null) {
            this.occasionalDelaySec = options.getOccasionalDelaySec();
        }
        if (options.getProbDelayedEvent() != null) {
            this.probDelayedEvent = options.getProbDelayedEvent();
        }
        if (options.getMaxLogEvents() != null) {
            this.maxLogEvents = options.getMaxLogEvents();
        }
        if (options.getUsePubsubPublishTime() != null) {
            this.usePubsubPublishTime = options.getUsePubsubPublishTime();
        }
        if (options.getOutOfOrderGroupSize() != null) {
            this.outOfOrderGroupSize = options.getOutOfOrderGroupSize();
        }
    }

    public NexmarkConfiguration copy() {
        NexmarkConfiguration result = new NexmarkConfiguration();
        result.debug = this.debug;
        result.query = this.query;
        result.sourceType = this.sourceType;
        result.sinkType = this.sinkType;
        result.exportSummaryToBigQuery = this.exportSummaryToBigQuery;
        result.pubSubMode = this.pubSubMode;
        result.numEvents = this.numEvents;
        result.numEventGenerators = this.numEventGenerators;
        result.rateShape = this.rateShape;
        result.firstEventRate = this.firstEventRate;
        result.nextEventRate = this.nextEventRate;
        result.rateUnit = this.rateUnit;
        result.ratePeriodSec = this.ratePeriodSec;
        result.preloadSeconds = this.preloadSeconds;
        result.streamTimeout = this.streamTimeout;
        result.isRateLimited = this.isRateLimited;
        result.useWallclockEventTime = this.useWallclockEventTime;
        result.avgPersonByteSize = this.avgPersonByteSize;
        result.avgAuctionByteSize = this.avgAuctionByteSize;
        result.avgBidByteSize = this.avgBidByteSize;
        result.hotAuctionRatio = this.hotAuctionRatio;
        result.hotSellersRatio = this.hotSellersRatio;
        result.hotBiddersRatio = this.hotBiddersRatio;
        result.windowSizeSec = this.windowSizeSec;
        result.windowPeriodSec = this.windowPeriodSec;
        result.watermarkHoldbackSec = this.watermarkHoldbackSec;
        result.numInFlightAuctions = this.numInFlightAuctions;
        result.numActivePeople = this.numActivePeople;
        result.coderStrategy = this.coderStrategy;
        result.cpuDelayMs = this.cpuDelayMs;
        result.diskBusyBytes = this.diskBusyBytes;
        result.auctionSkip = this.auctionSkip;
        result.fanout = this.fanout;
        result.maxAuctionsWaitingTime = this.maxAuctionsWaitingTime;
        result.occasionalDelaySec = this.occasionalDelaySec;
        result.probDelayedEvent = this.probDelayedEvent;
        result.maxLogEvents = this.maxLogEvents;
        result.usePubsubPublishTime = this.usePubsubPublishTime;
        result.outOfOrderGroupSize = this.outOfOrderGroupSize;
        return result;
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("query:%d", this.query));
        if (this.debug != NexmarkConfiguration.DEFAULT.debug) {
            sb.append(String.format("; debug:%s", this.debug));
        }
        if (this.sourceType != NexmarkConfiguration.DEFAULT.sourceType) {
            sb.append(String.format("; sourceType:%s", new Object[]{this.sourceType}));
        }
        if (this.sinkType != NexmarkConfiguration.DEFAULT.sinkType) {
            sb.append(String.format("; sinkType:%s", new Object[]{this.sinkType}));
        }
        if (this.exportSummaryToBigQuery != NexmarkConfiguration.DEFAULT.exportSummaryToBigQuery) {
            sb.append(String.format("; exportSummaryToBigQuery:%s", this.exportSummaryToBigQuery));
        }
        if (this.pubSubMode != NexmarkConfiguration.DEFAULT.pubSubMode) {
            sb.append(String.format("; pubSubMode:%s", new Object[]{this.pubSubMode}));
        }
        if (this.numEvents != NexmarkConfiguration.DEFAULT.numEvents) {
            sb.append(String.format("; numEvents:%d", this.numEvents));
        }
        if (this.numEventGenerators != NexmarkConfiguration.DEFAULT.numEventGenerators) {
            sb.append(String.format("; numEventGenerators:%d", this.numEventGenerators));
        }
        if (this.rateShape != NexmarkConfiguration.DEFAULT.rateShape) {
            sb.append(String.format("; rateShape:%s", new Object[]{this.rateShape}));
        }
        if (this.firstEventRate != NexmarkConfiguration.DEFAULT.firstEventRate || this.nextEventRate != NexmarkConfiguration.DEFAULT.nextEventRate) {
            sb.append(String.format("; firstEventRate:%d", this.firstEventRate));
            sb.append(String.format("; nextEventRate:%d", this.nextEventRate));
        }
        if (this.rateUnit != NexmarkConfiguration.DEFAULT.rateUnit) {
            sb.append(String.format("; rateUnit:%s", new Object[]{this.rateUnit}));
        }
        if (this.ratePeriodSec != NexmarkConfiguration.DEFAULT.ratePeriodSec) {
            sb.append(String.format("; ratePeriodSec:%d", this.ratePeriodSec));
        }
        if (this.preloadSeconds != NexmarkConfiguration.DEFAULT.preloadSeconds) {
            sb.append(String.format("; preloadSeconds:%d", this.preloadSeconds));
        }
        if (this.streamTimeout != NexmarkConfiguration.DEFAULT.streamTimeout) {
            sb.append(String.format("; streamTimeout:%d", this.streamTimeout));
        }
        if (this.isRateLimited != NexmarkConfiguration.DEFAULT.isRateLimited) {
            sb.append(String.format("; isRateLimited:%s", this.isRateLimited));
        }
        if (this.useWallclockEventTime != NexmarkConfiguration.DEFAULT.useWallclockEventTime) {
            sb.append(String.format("; useWallclockEventTime:%s", this.useWallclockEventTime));
        }
        if (this.avgPersonByteSize != NexmarkConfiguration.DEFAULT.avgPersonByteSize) {
            sb.append(String.format("; avgPersonByteSize:%d", this.avgPersonByteSize));
        }
        if (this.avgAuctionByteSize != NexmarkConfiguration.DEFAULT.avgAuctionByteSize) {
            sb.append(String.format("; avgAuctionByteSize:%d", this.avgAuctionByteSize));
        }
        if (this.avgBidByteSize != NexmarkConfiguration.DEFAULT.avgBidByteSize) {
            sb.append(String.format("; avgBidByteSize:%d", this.avgBidByteSize));
        }
        if (this.hotAuctionRatio != NexmarkConfiguration.DEFAULT.hotAuctionRatio) {
            sb.append(String.format("; hotAuctionRatio:%d", this.hotAuctionRatio));
        }
        if (this.hotSellersRatio != NexmarkConfiguration.DEFAULT.hotSellersRatio) {
            sb.append(String.format("; hotSellersRatio:%d", this.hotSellersRatio));
        }
        if (this.hotBiddersRatio != NexmarkConfiguration.DEFAULT.hotBiddersRatio) {
            sb.append(String.format("; hotBiddersRatio:%d", this.hotBiddersRatio));
        }
        if (this.windowSizeSec != NexmarkConfiguration.DEFAULT.windowSizeSec) {
            sb.append(String.format("; windowSizeSec:%d", this.windowSizeSec));
        }
        if (this.windowPeriodSec != NexmarkConfiguration.DEFAULT.windowPeriodSec) {
            sb.append(String.format("; windowPeriodSec:%d", this.windowPeriodSec));
        }
        if (this.watermarkHoldbackSec != NexmarkConfiguration.DEFAULT.watermarkHoldbackSec) {
            sb.append(String.format("; watermarkHoldbackSec:%d", this.watermarkHoldbackSec));
        }
        if (this.numInFlightAuctions != NexmarkConfiguration.DEFAULT.numInFlightAuctions) {
            sb.append(String.format("; numInFlightAuctions:%d", this.numInFlightAuctions));
        }
        if (this.numActivePeople != NexmarkConfiguration.DEFAULT.numActivePeople) {
            sb.append(String.format("; numActivePeople:%d", this.numActivePeople));
        }
        if (this.coderStrategy != NexmarkConfiguration.DEFAULT.coderStrategy) {
            sb.append(String.format("; coderStrategy:%s", new Object[]{this.coderStrategy}));
        }
        if (this.cpuDelayMs != NexmarkConfiguration.DEFAULT.cpuDelayMs) {
            sb.append(String.format("; cpuSlowdownMs:%d", this.cpuDelayMs));
        }
        if (this.diskBusyBytes != NexmarkConfiguration.DEFAULT.diskBusyBytes) {
            sb.append(String.format("; diskBuysBytes:%d", this.diskBusyBytes));
        }
        if (this.auctionSkip != NexmarkConfiguration.DEFAULT.auctionSkip) {
            sb.append(String.format("; auctionSkip:%d", this.auctionSkip));
        }
        if (this.fanout != NexmarkConfiguration.DEFAULT.fanout) {
            sb.append(String.format("; fanout:%d", this.fanout));
        }
        if (this.maxAuctionsWaitingTime != NexmarkConfiguration.DEFAULT.maxAuctionsWaitingTime) {
            sb.append(String.format("; maxAuctionsWaitingTime:%d", this.fanout));
        }
        if (this.occasionalDelaySec != NexmarkConfiguration.DEFAULT.occasionalDelaySec) {
            sb.append(String.format("; occasionalDelaySec:%d", this.occasionalDelaySec));
        }
        if (this.probDelayedEvent != NexmarkConfiguration.DEFAULT.probDelayedEvent) {
            sb.append(String.format("; probDelayedEvent:%f", this.probDelayedEvent));
        }
        if (this.maxLogEvents != NexmarkConfiguration.DEFAULT.maxLogEvents) {
            sb.append(String.format("; maxLogEvents:%d", this.maxLogEvents));
        }
        if (this.usePubsubPublishTime != NexmarkConfiguration.DEFAULT.usePubsubPublishTime) {
            sb.append(String.format("; usePubsubPublishTime:%s", this.usePubsubPublishTime));
        }
        if (this.outOfOrderGroupSize != NexmarkConfiguration.DEFAULT.outOfOrderGroupSize) {
            sb.append(String.format("; outOfOrderGroupSize:%d", this.outOfOrderGroupSize));
        }
        return sb.toString();
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NexmarkConfiguration fromString(String string) {
        try {
            return (NexmarkConfiguration)NexmarkUtils.MAPPER.readValue(string, NexmarkConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse nexmark configuration: ", e);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.debug, this.query, this.sourceType, this.sinkType, this.exportSummaryToBigQuery, this.pubSubMode, this.numEvents, this.numEventGenerators, this.rateShape, this.firstEventRate, this.nextEventRate, this.rateUnit, this.ratePeriodSec, this.preloadSeconds, this.streamTimeout, this.isRateLimited, this.useWallclockEventTime, this.avgPersonByteSize, this.avgAuctionByteSize, this.avgBidByteSize, this.hotAuctionRatio, this.hotSellersRatio, this.hotBiddersRatio, this.windowSizeSec, this.windowPeriodSec, this.watermarkHoldbackSec, this.numInFlightAuctions, this.numActivePeople, this.coderStrategy, this.cpuDelayMs, this.diskBusyBytes, this.auctionSkip, this.fanout, this.maxAuctionsWaitingTime, this.occasionalDelaySec, this.probDelayedEvent, this.maxLogEvents, this.usePubsubPublishTime, this.outOfOrderGroupSize});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NexmarkConfiguration other = (NexmarkConfiguration)obj;
        if (this.debug != other.debug) {
            return false;
        }
        if (this.auctionSkip != other.auctionSkip) {
            return false;
        }
        if (this.avgAuctionByteSize != other.avgAuctionByteSize) {
            return false;
        }
        if (this.avgBidByteSize != other.avgBidByteSize) {
            return false;
        }
        if (this.avgPersonByteSize != other.avgPersonByteSize) {
            return false;
        }
        if (this.coderStrategy != other.coderStrategy) {
            return false;
        }
        if (this.cpuDelayMs != other.cpuDelayMs) {
            return false;
        }
        if (this.diskBusyBytes != other.diskBusyBytes) {
            return false;
        }
        if (this.fanout != other.fanout) {
            return false;
        }
        if (this.maxAuctionsWaitingTime != other.maxAuctionsWaitingTime) {
            return false;
        }
        if (this.firstEventRate != other.firstEventRate) {
            return false;
        }
        if (this.hotAuctionRatio != other.hotAuctionRatio) {
            return false;
        }
        if (this.hotBiddersRatio != other.hotBiddersRatio) {
            return false;
        }
        if (this.hotSellersRatio != other.hotSellersRatio) {
            return false;
        }
        if (this.isRateLimited != other.isRateLimited) {
            return false;
        }
        if (this.maxLogEvents != other.maxLogEvents) {
            return false;
        }
        if (this.nextEventRate != other.nextEventRate) {
            return false;
        }
        if (this.rateUnit != other.rateUnit) {
            return false;
        }
        if (this.numEventGenerators != other.numEventGenerators) {
            return false;
        }
        if (this.numEvents != other.numEvents) {
            return false;
        }
        if (this.numInFlightAuctions != other.numInFlightAuctions) {
            return false;
        }
        if (this.numActivePeople != other.numActivePeople) {
            return false;
        }
        if (this.occasionalDelaySec != other.occasionalDelaySec) {
            return false;
        }
        if (this.preloadSeconds != other.preloadSeconds) {
            return false;
        }
        if (this.streamTimeout != other.streamTimeout) {
            return false;
        }
        if (Double.doubleToLongBits(this.probDelayedEvent) != Double.doubleToLongBits(other.probDelayedEvent)) {
            return false;
        }
        if (this.pubSubMode != other.pubSubMode) {
            return false;
        }
        if (this.ratePeriodSec != other.ratePeriodSec) {
            return false;
        }
        if (this.rateShape != other.rateShape) {
            return false;
        }
        if (this.query != other.query) {
            return false;
        }
        if (this.sinkType != other.sinkType) {
            return false;
        }
        if (this.exportSummaryToBigQuery != other.exportSummaryToBigQuery) {
            return false;
        }
        if (this.sourceType != other.sourceType) {
            return false;
        }
        if (this.useWallclockEventTime != other.useWallclockEventTime) {
            return false;
        }
        if (this.watermarkHoldbackSec != other.watermarkHoldbackSec) {
            return false;
        }
        if (this.windowPeriodSec != other.windowPeriodSec) {
            return false;
        }
        if (this.windowSizeSec != other.windowSizeSec) {
            return false;
        }
        if (this.usePubsubPublishTime != other.usePubsubPublishTime) {
            return false;
        }
        return this.outOfOrderGroupSize == other.outOfOrderGroupSize;
    }
}

