/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark;

import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.nexmark.NexmarkSuite;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;

public interface NexmarkOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions,
PubsubOptions,
StreamingOptions {
    @Description(value="Which suite to run. Default is to use command line arguments for one job.")
    @Default.Enum(value="DEFAULT")
    public NexmarkSuite getSuite();

    public void setSuite(NexmarkSuite var1);

    @Description(value="If true, monitor the jobs as they run.")
    @Default.Boolean(value=false)
    public boolean getMonitorJobs();

    public void setMonitorJobs(boolean var1);

    @Description(value="Where the events come from.")
    @Nullable
    public NexmarkUtils.SourceType getSourceType();

    public void setSourceType(NexmarkUtils.SourceType var1);

    @Description(value="Prefix for input files if using avro input")
    @Nullable
    public String getInputPath();

    public void setInputPath(String var1);

    @Description(value="Where results go.")
    @Nullable
    public NexmarkUtils.SinkType getSinkType();

    public void setSinkType(NexmarkUtils.SinkType var1);

    @Description(value="Shall we export the summary to BigQuery.")
    @Default.Boolean(value=false)
    public Boolean getExportSummaryToBigQuery();

    public void setExportSummaryToBigQuery(Boolean var1);

    @Description(value="Which mode to run in when source is PUBSUB.")
    @Nullable
    public NexmarkUtils.PubSubMode getPubSubMode();

    public void setPubSubMode(NexmarkUtils.PubSubMode var1);

    @Description(value="Which query to run.")
    @Nullable
    public Integer getQuery();

    public void setQuery(Integer var1);

    @Description(value="Prefix for output files if using text output for results or running Query 10.")
    @Nullable
    public String getOutputPath();

    public void setOutputPath(String var1);

    @Description(value="Base name of pubsub topic to publish to in streaming mode.")
    @Nullable
    @Default.String(value="nexmark")
    public String getPubsubTopic();

    public void setPubsubTopic(String var1);

    @Description(value="Base name of pubsub subscription to read from in streaming mode.")
    @Nullable
    @Default.String(value="nexmark")
    public String getPubsubSubscription();

    public void setPubsubSubscription(String var1);

    @Description(value="Base name of BigQuery table name if using BigQuery output.")
    @Nullable
    @Default.String(value="nexmark")
    public String getBigQueryTable();

    public void setBigQueryTable(String var1);

    @Description(value="BigQuery dataset")
    @Default.String(value="nexmark")
    public String getBigQueryDataset();

    public void setBigQueryDataset(String var1);

    @Description(value="Approximate number of events to generate. Zero for effectively unlimited in streaming mode.")
    @Nullable
    public Long getNumEvents();

    public void setNumEvents(Long var1);

    @Description(value="Time in seconds to preload the subscription with data, at the initial input rate of the pipeline.")
    @Nullable
    public Integer getPreloadSeconds();

    public void setPreloadSeconds(Integer var1);

    @Description(value="Time in seconds to wait in pipelineResult.waitUntilFinish(), useful in streaming mode")
    @Nullable
    public Integer getStreamTimeout();

    public void setStreamTimeout(Integer var1);

    @Description(value="Number of unbounded sources to create events.")
    @Nullable
    public Integer getNumEventGenerators();

    public void setNumEventGenerators(Integer var1);

    @Description(value="Shape of event rate curve.")
    @Nullable
    public NexmarkUtils.RateShape getRateShape();

    public void setRateShape(NexmarkUtils.RateShape var1);

    @Description(value="Initial overall event rate (in --rateUnit).")
    @Nullable
    public Integer getFirstEventRate();

    public void setFirstEventRate(Integer var1);

    @Description(value="Next overall event rate (in --rateUnit).")
    @Nullable
    public Integer getNextEventRate();

    public void setNextEventRate(Integer var1);

    @Description(value="Unit for rates.")
    @Nullable
    public NexmarkUtils.RateUnit getRateUnit();

    public void setRateUnit(NexmarkUtils.RateUnit var1);

    @Description(value="Overall period of rate shape, in seconds.")
    @Nullable
    public Integer getRatePeriodSec();

    public void setRatePeriodSec(Integer var1);

    @Description(value="If true, relay events in real time in streaming mode.")
    @Nullable
    public Boolean getIsRateLimited();

    public void setIsRateLimited(Boolean var1);

    @Description(value="If true, use wallclock time as event time. Otherwise, use a deterministic time in the past so that multiple runs will see exactly the same event streams and should thus have exactly the same results.")
    @Nullable
    public Boolean getUseWallclockEventTime();

    public void setUseWallclockEventTime(Boolean var1);

    @Description(value="Assert pipeline results match model results.")
    public boolean getAssertCorrectness();

    public void setAssertCorrectness(boolean var1);

    @Description(value="Log all input events.")
    public boolean getLogEvents();

    public void setLogEvents(boolean var1);

    @Description(value="Log all query results.")
    public boolean getLogResults();

    public void setLogResults(boolean var1);

    @Description(value="Average size in bytes for a person record.")
    @Nullable
    public Integer getAvgPersonByteSize();

    public void setAvgPersonByteSize(Integer var1);

    @Description(value="Average size in bytes for an auction record.")
    @Nullable
    public Integer getAvgAuctionByteSize();

    public void setAvgAuctionByteSize(Integer var1);

    @Description(value="Average size in bytes for a bid record.")
    @Nullable
    public Integer getAvgBidByteSize();

    public void setAvgBidByteSize(Integer var1);

    @Description(value="Ratio of bids for 'hot' auctions above the background.")
    @Nullable
    public Integer getHotAuctionRatio();

    public void setHotAuctionRatio(Integer var1);

    @Description(value="Ratio of auctions for 'hot' sellers above the background.")
    @Nullable
    public Integer getHotSellersRatio();

    public void setHotSellersRatio(Integer var1);

    @Description(value="Ratio of auctions for 'hot' bidders above the background.")
    @Nullable
    public Integer getHotBiddersRatio();

    public void setHotBiddersRatio(Integer var1);

    @Description(value="Window size in seconds.")
    @Nullable
    public Long getWindowSizeSec();

    public void setWindowSizeSec(Long var1);

    @Description(value="Window period in seconds.")
    @Nullable
    public Long getWindowPeriodSec();

    public void setWindowPeriodSec(Long var1);

    @Description(value="If in streaming mode, the holdback for watermark in seconds.")
    @Nullable
    public Long getWatermarkHoldbackSec();

    public void setWatermarkHoldbackSec(Long var1);

    @Description(value="Roughly how many auctions should be in flight for each generator.")
    @Nullable
    public Integer getNumInFlightAuctions();

    public void setNumInFlightAuctions(Integer var1);

    @Description(value="Maximum number of people to consider as active for placing auctions or bids.")
    @Nullable
    public Integer getNumActivePeople();

    public void setNumActivePeople(Integer var1);

    @Description(value="Filename of perf data to append to.")
    @Nullable
    public String getPerfFilename();

    public void setPerfFilename(String var1);

    @Description(value="Filename of baseline perf data to read from.")
    @Nullable
    public String getBaselineFilename();

    public void setBaselineFilename(String var1);

    @Description(value="Filename of summary perf data to append to.")
    @Nullable
    public String getSummaryFilename();

    public void setSummaryFilename(String var1);

    @Description(value="Filename for javascript capturing all perf data and any baselines.")
    @Nullable
    public String getJavascriptFilename();

    public void setJavascriptFilename(String var1);

    @Description(value="If true, don't run the actual query. Instead, calculate the distribution of number of query results per (event time) minute according to the query model.")
    public boolean getJustModelResultRate();

    public void setJustModelResultRate(boolean var1);

    @Description(value="Coder strategy to use.")
    @Nullable
    public NexmarkUtils.CoderStrategy getCoderStrategy();

    public void setCoderStrategy(NexmarkUtils.CoderStrategy var1);

    @Description(value="Delay, in milliseconds, for each event. We will peg one core for this number of milliseconds to simulate CPU-bound computation.")
    @Nullable
    public Long getCpuDelayMs();

    public void setCpuDelayMs(Long var1);

    @Description(value="Extra data, in bytes, to save to persistent state for each event. This will force I/O all the way to durable storage to simulate an I/O-bound computation.")
    @Nullable
    public Long getDiskBusyBytes();

    public void setDiskBusyBytes(Long var1);

    @Description(value="Skip factor for query 2. We select bids for every {@code auctionSkip}'th auction")
    @Nullable
    public Integer getAuctionSkip();

    public void setAuctionSkip(Integer var1);

    @Description(value="Fanout for queries 4 (groups by category id) and 7 (finds a global maximum).")
    @Nullable
    public Integer getFanout();

    public void setFanout(Integer var1);

    @Description(value="Maximum waiting time to clean personState in query3 (ie maximum waiting of the auctions related to person in state in seconds in event time).")
    @Nullable
    public Integer getMaxAuctionsWaitingTime();

    public void setMaxAuctionsWaitingTime(Integer var1);

    @Description(value="Length of occasional delay to impose on events (in seconds).")
    @Nullable
    public Long getOccasionalDelaySec();

    public void setOccasionalDelaySec(Long var1);

    @Description(value="Probability that an event will be delayed by delayS.")
    @Nullable
    public Double getProbDelayedEvent();

    public void setProbDelayedEvent(Double var1);

    @Description(value="Maximum size of each log file (in events). For Query10 only.")
    @Nullable
    public Integer getMaxLogEvents();

    public void setMaxLogEvents(Integer var1);

    @Description(value="How to derive names of resources.")
    @Default.Enum(value="QUERY_AND_SALT")
    public NexmarkUtils.ResourceNameMode getResourceNameMode();

    public void setResourceNameMode(NexmarkUtils.ResourceNameMode var1);

    @Description(value="If true, manage the creation and cleanup of topics, subscriptions and gcs files.")
    @Default.Boolean(value=true)
    public boolean getManageResources();

    public void setManageResources(boolean var1);

    @Description(value="If true, use pub/sub publish time instead of event time.")
    @Nullable
    public Boolean getUsePubsubPublishTime();

    public void setUsePubsubPublishTime(Boolean var1);

    @Description(value="Number of events in out-of-order groups. 1 implies no out-of-order events. 1000 implies every 1000 events per generator are emitted in pseudo-random order.")
    @Nullable
    public Long getOutOfOrderGroupSize();

    public void setOutOfOrderGroupSize(Long var1);

    @Description(value="If false, do not add the Monitor and Snoop transforms.")
    @Nullable
    public Boolean getDebug();

    public void setDebug(Boolean var1);

    @Description(value="If set, cancel running pipelines after this long")
    @Nullable
    public Long getRunningTimeMinutes();

    public void setRunningTimeMinutes(Long var1);

    @Description(value="If set and --monitorJobs is true, check that the system watermark is never more than this far behind real time")
    @Nullable
    public Long getMaxSystemLagSeconds();

    public void setMaxSystemLagSeconds(Long var1);

    @Description(value="If set and --monitorJobs is true, check that the data watermark is never more than this far behind real time")
    @Nullable
    public Long getMaxDataLagSeconds();

    public void setMaxDataLagSeconds(Long var1);

    @Description(value="Only start validating watermarks after this many seconds")
    @Nullable
    public Long getWatermarkValidationDelaySeconds();

    public void setWatermarkValidationDelaySeconds(Long var1);

    @Description(value="Specify 'sql' to use Beam SQL queries. Otherwise Java transforms will be used")
    @Nullable
    public String getQueryLanguage();

    public void setQueryLanguage(String var1);

    @Description(value="Base name of Kafka events topic in streaming mode.")
    @Nullable
    @Default.String(value="nexmark")
    public String getKafkaTopic();

    public void setKafkaTopic(String var1);

    @Description(value="Base name of Kafka results topic in streaming mode.")
    @Nullable
    @Default.String(value="nexmark-results")
    public String getKafkaResultsTopic();

    public void setKafkaResultsTopic(String var1);

    @Description(value="Kafka Bootstrap Server domains.")
    @Nullable
    public String getBootstrapServers();

    public void setBootstrapServers(String var1);

    @Description(value="Same as --numWorkers in DataflowPipelineWorkerPoolOptions")
    public int getNumWorkers();

    public void setNumWorkers(int var1);

    @Description(value="Same as --maxNumWorkers in DataflowPipelineWorkerPoolOptions.")
    public int getMaxNumWorkers();

    public void setMaxNumWorkers(int var1);
}

