/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.nexmark.NexmarkUtils;

public class NexmarkPerf {
    @JsonProperty
    @Nullable
    public List<ProgressSnapshot> snapshots = null;
    @JsonProperty
    public double runtimeSec = -1.0;
    @JsonProperty
    public long numEvents = -1L;
    @JsonProperty
    public double eventsPerSec = -1.0;
    @JsonProperty
    public double eventBytesPerSec = -1.0;
    @JsonProperty
    public long numResults = -1L;
    @JsonProperty
    public double resultsPerSec = -1.0;
    @JsonProperty
    public double resultBytesPerSec = -1.0;
    @JsonProperty
    public double startupDelaySec = -1.0;
    @JsonProperty
    public double processingDelaySec = -1.0;
    @JsonProperty
    public double shutdownDelaySec = -1.0;
    @JsonProperty
    double timeDilation = -1.0;
    @JsonProperty
    @Nullable
    public List<String> errors = null;
    @JsonProperty
    @Nullable
    public String jobId = null;

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NexmarkPerf fromString(String string) {
        try {
            return (NexmarkPerf)NexmarkUtils.MAPPER.readValue(string, NexmarkPerf.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse nexmark perf: ", e);
        }
    }

    public boolean anyActivity(NexmarkPerf that) {
        if (this.runtimeSec != that.runtimeSec) {
            return true;
        }
        if (this.numEvents != that.numEvents) {
            return true;
        }
        return this.numResults != that.numResults;
    }

    public static class ProgressSnapshot {
        @JsonProperty
        double secSinceStart;
        @JsonProperty
        double runtimeSec;
        @JsonProperty
        long numEvents;
        @JsonProperty
        long numResults;

        public boolean anyActivity(ProgressSnapshot that) {
            if (this.runtimeSec != that.runtimeSec) {
                return true;
            }
            if (this.numEvents != that.numEvents) {
                return true;
            }
            return this.numResults != that.numResults;
        }
    }
}

