/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkOptions;
import org.apache.beam.sdk.nexmark.NexmarkUtils;

public enum NexmarkSuite {
    DEFAULT(NexmarkSuite.defaultConf()),
    SMOKE(NexmarkSuite.smoke()),
    STRESS(NexmarkSuite.stress()),
    FULL_THROTTLE(NexmarkSuite.fullThrottle()),
    LONG_RUNNING_LOGGER(NexmarkSuite.longRunningLogger());

    private final List<NexmarkConfiguration> configurations;

    private static List<NexmarkConfiguration> defaultConf() {
        ArrayList<NexmarkConfiguration> configurations = new ArrayList<NexmarkConfiguration>();
        NexmarkConfiguration configuration = new NexmarkConfiguration();
        configurations.add(configuration);
        return configurations;
    }

    private static List<NexmarkConfiguration> smoke() {
        ArrayList<NexmarkConfiguration> configurations = new ArrayList<NexmarkConfiguration>();
        for (int query = 0; query <= 12; ++query) {
            NexmarkConfiguration configuration = NexmarkConfiguration.DEFAULT.copy();
            configuration.query = query;
            configuration.numEvents = 100000L;
            if (query == 4 || query == 6 || query == 9) {
                configuration.numEvents /= 10L;
            }
            configurations.add(configuration);
        }
        return configurations;
    }

    private static List<NexmarkConfiguration> stress() {
        List<NexmarkConfiguration> configurations = NexmarkSuite.smoke();
        for (NexmarkConfiguration configuration : configurations) {
            if (configuration.numEvents < 0L) continue;
            configuration.numEvents *= 1000L;
        }
        return configurations;
    }

    private static List<NexmarkConfiguration> fullThrottle() {
        List<NexmarkConfiguration> configurations = NexmarkSuite.smoke();
        for (NexmarkConfiguration configuration : configurations) {
            if (configuration.numEvents < 0L) continue;
            configuration.numEvents *= 1000L;
        }
        return configurations;
    }

    private static List<NexmarkConfiguration> longRunningLogger() {
        NexmarkConfiguration configuration = NexmarkConfiguration.DEFAULT.copy();
        configuration.numEventGenerators = 10;
        configuration.query = 10;
        configuration.isRateLimited = true;
        configuration.sourceType = NexmarkUtils.SourceType.PUBSUB;
        configuration.numEvents = 0L;
        configuration.avgPersonByteSize = 500;
        configuration.avgAuctionByteSize = 500;
        configuration.avgBidByteSize = 500;
        configuration.windowSizeSec = 300L;
        configuration.occasionalDelaySec = 360L;
        configuration.probDelayedEvent = 0.001;
        configuration.useWallclockEventTime = true;
        configuration.firstEventRate = 60000;
        configuration.nextEventRate = 60000;
        configuration.maxLogEvents = 15000;
        ArrayList<NexmarkConfiguration> configurations = new ArrayList<NexmarkConfiguration>();
        configurations.add(configuration);
        return configurations;
    }

    private NexmarkSuite(List<NexmarkConfiguration> configurations) {
        this.configurations = configurations;
    }

    public Iterable<NexmarkConfiguration> getConfigurations(NexmarkOptions options) {
        LinkedHashSet<NexmarkConfiguration> results = new LinkedHashSet<NexmarkConfiguration>();
        for (NexmarkConfiguration configuration : this.configurations) {
            NexmarkConfiguration result = configuration.copy();
            result.overrideFromOptions(options);
            results.add(result);
        }
        return results;
    }
}

