/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubJsonClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.joda.time.Duration;

public class PubsubHelper {
    private final PubsubClient pubsubClient;
    private final String project;
    private final List<PubsubClient.TopicPath> createdTopics;
    private final List<PubsubClient.SubscriptionPath> createdSubscriptions;
    private final Sleeper sleeper;
    private final BackOff backOff;

    private PubsubHelper(PubsubClient pubsubClient, String project) {
        this.pubsubClient = pubsubClient;
        this.project = project;
        this.createdTopics = new ArrayList<PubsubClient.TopicPath>();
        this.createdSubscriptions = new ArrayList<PubsubClient.SubscriptionPath>();
        this.sleeper = Sleeper.DEFAULT;
        this.backOff = FluentBackoff.DEFAULT.withInitialBackoff(Duration.standardSeconds((long)1L)).withMaxRetries(3).backoff();
    }

    public static PubsubHelper create(PubsubOptions options) throws IOException {
        return new PubsubHelper(PubsubJsonClient.FACTORY.newClient(null, null, options), options.getProject());
    }

    public PubsubClient.TopicPath createTopic(String shortTopic) throws IOException {
        PubsubClient.TopicPath topic = PubsubClient.topicPathFromName((String)this.project, (String)shortTopic);
        while (true) {
            try {
                NexmarkUtils.console("create topic %s", topic);
                this.pubsubClient.createTopic(topic);
                this.createdTopics.add(topic);
                return topic;
            }
            catch (GoogleJsonResponseException ex) {
                NexmarkUtils.console("attempting to cleanup topic %s", topic);
                this.pubsubClient.deleteTopic(topic);
                try {
                    if (BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.backOff)) continue;
                    NexmarkUtils.console("too many retries for creating topic %s", topic);
                    throw ex;
                }
                catch (InterruptedException in) {
                    throw new IOException(in);
                }
            }
            break;
        }
    }

    public PubsubClient.TopicPath createOrReuseTopic(String shortTopic) throws IOException {
        PubsubClient.TopicPath topic = PubsubClient.topicPathFromName((String)this.project, (String)shortTopic);
        while (true) {
            try {
                NexmarkUtils.console("create topic %s", topic);
                this.pubsubClient.createTopic(topic);
                return topic;
            }
            catch (GoogleJsonResponseException ex) {
                if (this.topicExists(shortTopic)) {
                    NexmarkUtils.console("topic %s already exists", topic);
                    return topic;
                }
                try {
                    if (BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.backOff)) continue;
                    NexmarkUtils.console("too many retries for creating/reusing topic %s", topic);
                    throw ex;
                }
                catch (InterruptedException in) {
                    throw new IOException(in);
                }
            }
            break;
        }
    }

    public PubsubClient.TopicPath reuseTopic(String shortTopic) throws IOException {
        PubsubClient.TopicPath topic = PubsubClient.topicPathFromName((String)this.project, (String)shortTopic);
        if (this.topicExists(shortTopic)) {
            NexmarkUtils.console("reusing existing topic %s", topic);
            return topic;
        }
        throw new RuntimeException("topic '" + topic + "' does not already exist");
    }

    public boolean topicExists(String shortTopic) throws IOException {
        PubsubClient.TopicPath topic = PubsubClient.topicPathFromName((String)this.project, (String)shortTopic);
        return this.pubsubClient.listTopics(PubsubClient.projectPathFromId((String)this.project)).stream().anyMatch(arg_0 -> ((PubsubClient.TopicPath)topic).equals(arg_0));
    }

    public PubsubClient.SubscriptionPath createSubscription(String shortTopic, String shortSubscription) throws IOException {
        PubsubClient.TopicPath topic = PubsubClient.topicPathFromName((String)this.project, (String)shortTopic);
        PubsubClient.SubscriptionPath subscription = PubsubClient.subscriptionPathFromName((String)this.project, (String)shortSubscription);
        while (true) {
            try {
                NexmarkUtils.console("create subscription %s", subscription);
                this.pubsubClient.createSubscription(topic, subscription, 60);
                this.createdSubscriptions.add(subscription);
                return subscription;
            }
            catch (GoogleJsonResponseException ex) {
                NexmarkUtils.console("attempting to cleanup subscription %s", subscription);
                this.pubsubClient.deleteSubscription(subscription);
                try {
                    if (BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.backOff)) continue;
                    NexmarkUtils.console("too many retries for creating subscription %s", subscription);
                    throw ex;
                }
                catch (InterruptedException in) {
                    throw new IOException(in);
                }
            }
            break;
        }
    }

    public PubsubClient.SubscriptionPath reuseSubscription(String shortTopic, String shortSubscription) throws IOException {
        PubsubClient.SubscriptionPath subscription = PubsubClient.subscriptionPathFromName((String)this.project, (String)shortSubscription);
        if (this.subscriptionExists(shortTopic, shortSubscription)) {
            NexmarkUtils.console("reusing existing subscription %s", subscription);
            return subscription;
        }
        throw new RuntimeException("subscription'" + subscription + "' does not already exist");
    }

    public boolean subscriptionExists(String shortTopic, String shortSubscription) throws IOException {
        PubsubClient.TopicPath topic = PubsubClient.topicPathFromName((String)this.project, (String)shortTopic);
        PubsubClient.SubscriptionPath subscription = PubsubClient.subscriptionPathFromName((String)this.project, (String)shortSubscription);
        return this.pubsubClient.listSubscriptions(PubsubClient.projectPathFromId((String)this.project), topic).stream().anyMatch(arg_0 -> ((PubsubClient.SubscriptionPath)subscription).equals(arg_0));
    }

    public void cleanup() {
        for (PubsubClient.SubscriptionPath subscription : this.createdSubscriptions) {
            try {
                NexmarkUtils.console("delete subscription %s", subscription);
                this.pubsubClient.deleteSubscription(subscription);
            }
            catch (IOException ex) {
                NexmarkUtils.console("could not delete subscription %s", subscription);
            }
        }
        for (PubsubClient.TopicPath topic : this.createdTopics) {
            try {
                NexmarkUtils.console("delete topic %s", topic);
                this.pubsubClient.deleteTopic(topic);
            }
            catch (IOException ex) {
                NexmarkUtils.console("could not delete topic %s", topic);
            }
        }
    }
}

