/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class Auction
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();
    public static final Coder<Auction> CODER = new CustomCoder<Auction>(){

        public void encode(Auction value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.id, outStream);
            STRING_CODER.encode((Object)value.itemName, outStream);
            STRING_CODER.encode((Object)value.description, outStream);
            LONG_CODER.encode((Object)value.initialBid, outStream);
            LONG_CODER.encode((Object)value.reserve, outStream);
            LONG_CODER.encode((Object)value.dateTime, outStream);
            LONG_CODER.encode((Object)value.expires, outStream);
            LONG_CODER.encode((Object)value.seller, outStream);
            LONG_CODER.encode((Object)value.category, outStream);
            STRING_CODER.encode((Object)value.extra, outStream);
        }

        public Auction decode(InputStream inStream) throws CoderException, IOException {
            long id = (Long)LONG_CODER.decode(inStream);
            String itemName = (String)STRING_CODER.decode(inStream);
            String description = (String)STRING_CODER.decode(inStream);
            long initialBid = (Long)LONG_CODER.decode(inStream);
            long reserve = (Long)LONG_CODER.decode(inStream);
            long dateTime = (Long)LONG_CODER.decode(inStream);
            long expires = (Long)LONG_CODER.decode(inStream);
            long seller = (Long)LONG_CODER.decode(inStream);
            long category = (Long)LONG_CODER.decode(inStream);
            String extra = (String)STRING_CODER.decode(inStream);
            return new Auction(id, itemName, description, initialBid, reserve, dateTime, expires, seller, category, extra);
        }

        public Object structuralValue(Auction v) {
            return v;
        }
    };
    @JsonProperty
    public final long id;
    @JsonProperty
    public final String itemName;
    @JsonProperty
    public final String description;
    @JsonProperty
    public final long initialBid;
    @JsonProperty
    public final long reserve;
    @JsonProperty
    public final long dateTime;
    @JsonProperty
    public final long expires;
    @JsonProperty
    public final long seller;
    @JsonProperty
    public final long category;
    @JsonProperty
    public final String extra;

    private Auction() {
        this.id = 0L;
        this.itemName = null;
        this.description = null;
        this.initialBid = 0L;
        this.reserve = 0L;
        this.dateTime = 0L;
        this.expires = 0L;
        this.seller = 0L;
        this.category = 0L;
        this.extra = null;
    }

    public Auction(long id, String itemName, String description, long initialBid, long reserve, long dateTime, long expires, long seller, long category, String extra) {
        this.id = id;
        this.itemName = itemName;
        this.description = description;
        this.initialBid = initialBid;
        this.reserve = reserve;
        this.dateTime = dateTime;
        this.expires = expires;
        this.seller = seller;
        this.category = category;
        this.extra = extra;
    }

    public Auction withAnnotation(String annotation) {
        return new Auction(this.id, this.itemName, this.description, this.initialBid, this.reserve, this.dateTime, this.expires, this.seller, this.category, annotation + ": " + this.extra);
    }

    public boolean hasAnnotation(String annotation) {
        return this.extra.startsWith(annotation + ": ");
    }

    public Auction withoutAnnotation(String annotation) {
        if (this.hasAnnotation(annotation)) {
            return new Auction(this.id, this.itemName, this.description, this.initialBid, this.reserve, this.dateTime, this.expires, this.seller, this.category, this.extra.substring(annotation.length() + 2));
        }
        return this;
    }

    @Override
    public long sizeInBytes() {
        return 8L + (long)this.itemName.length() + 1L + (long)this.description.length() + 1L + 8L + 8L + 8L + 8L + 8L + 8L + (long)this.extra.length() + 1L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Auction auction = (Auction)o;
        return this.id == auction.id && this.initialBid == auction.initialBid && this.reserve == auction.reserve && this.dateTime == auction.dateTime && this.expires == auction.expires && this.seller == auction.seller && this.category == auction.category && Objects.equal(this.itemName, auction.itemName) && Objects.equal(this.description, auction.description) && Objects.equal(this.extra, auction.extra);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.itemName, this.description, this.initialBid, this.reserve, this.dateTime, this.expires, this.seller, this.category, this.extra);
    }
}

