/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class AuctionBid
implements KnownSize,
Serializable {
    public static final Coder<AuctionBid> CODER = new CustomCoder<AuctionBid>(){

        public void encode(AuctionBid value, OutputStream outStream) throws CoderException, IOException {
            Auction.CODER.encode((Object)value.auction, outStream);
            Bid.CODER.encode((Object)value.bid, outStream);
        }

        public AuctionBid decode(InputStream inStream) throws CoderException, IOException {
            Auction auction = (Auction)Auction.CODER.decode(inStream);
            Bid bid = (Bid)Bid.CODER.decode(inStream);
            return new AuctionBid(auction, bid);
        }

        public Object structuralValue(AuctionBid v) {
            return v;
        }
    };
    @JsonProperty
    public final Auction auction;
    @JsonProperty
    public final Bid bid;

    private AuctionBid() {
        this.auction = null;
        this.bid = null;
    }

    public AuctionBid(Auction auction, Bid bid) {
        this.auction = auction;
        this.bid = bid;
    }

    @Override
    public long sizeInBytes() {
        return this.auction.sizeInBytes() + this.bid.sizeInBytes();
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuctionBid that = (AuctionBid)o;
        return Objects.equal(this.auction, that.auction) && Objects.equal(this.bid, that.bid);
    }

    public int hashCode() {
        return Objects.hashCode(this.auction, this.bid);
    }
}

