/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class AuctionCount
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    public static final Coder<AuctionCount> CODER = new CustomCoder<AuctionCount>(){

        public void encode(AuctionCount value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.auction, outStream);
            LONG_CODER.encode((Object)value.num, outStream);
        }

        public AuctionCount decode(InputStream inStream) throws CoderException, IOException {
            long auction = (Long)LONG_CODER.decode(inStream);
            long num = (Long)LONG_CODER.decode(inStream);
            return new AuctionCount(auction, num);
        }

        public Object structuralValue(AuctionCount v) {
            return v;
        }
    };
    @JsonProperty
    public final long auction;
    @JsonProperty
    public final long num;

    private AuctionCount() {
        this.auction = 0L;
        this.num = 0L;
    }

    public AuctionCount(long auction, long num) {
        this.auction = auction;
        this.num = num;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        AuctionCount other = (AuctionCount)otherObject;
        return Objects.equals(this.auction, other.auction) && Objects.equals(this.num, other.num);
    }

    public int hashCode() {
        return Objects.hash(this.auction, this.num);
    }

    @Override
    public long sizeInBytes() {
        return 16L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

