/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class AuctionPrice
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    public static final Coder<AuctionPrice> CODER = new CustomCoder<AuctionPrice>(){

        public void encode(AuctionPrice value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.auction, outStream);
            LONG_CODER.encode((Object)value.price, outStream);
        }

        public AuctionPrice decode(InputStream inStream) throws CoderException, IOException {
            long auction = (Long)LONG_CODER.decode(inStream);
            long price = (Long)LONG_CODER.decode(inStream);
            return new AuctionPrice(auction, price);
        }

        public Object structuralValue(AuctionPrice v) {
            return v;
        }
    };
    @JsonProperty
    public final long auction;
    @JsonProperty
    public final long price;

    private AuctionPrice() {
        this.auction = 0L;
        this.price = 0L;
    }

    public AuctionPrice(long auction, long price) {
        this.auction = auction;
        this.price = price;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        AuctionPrice other = (AuctionPrice)otherObject;
        return Objects.equals(this.auction, other.auction) && Objects.equals(this.price, other.price);
    }

    public int hashCode() {
        return Objects.hash(this.auction, this.price);
    }

    @Override
    public long sizeInBytes() {
        return 16L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

