/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class Bid
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();
    public static final Coder<Bid> CODER = new CustomCoder<Bid>(){

        public void encode(Bid value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.auction, outStream);
            LONG_CODER.encode((Object)value.bidder, outStream);
            LONG_CODER.encode((Object)value.price, outStream);
            LONG_CODER.encode((Object)value.dateTime, outStream);
            STRING_CODER.encode((Object)value.extra, outStream);
        }

        public Bid decode(InputStream inStream) throws CoderException, IOException {
            long auction = (Long)LONG_CODER.decode(inStream);
            long bidder = (Long)LONG_CODER.decode(inStream);
            long price = (Long)LONG_CODER.decode(inStream);
            long dateTime = (Long)LONG_CODER.decode(inStream);
            String extra = (String)STRING_CODER.decode(inStream);
            return new Bid(auction, bidder, price, dateTime, extra);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(Bid v) {
            return v;
        }
    };
    public static final Comparator<Bid> PRICE_THEN_DESCENDING_TIME = (left, right) -> {
        int i = Double.compare(left.price, right.price);
        if (i != 0) {
            return i;
        }
        return Long.compare(right.dateTime, left.dateTime);
    };
    public static final Comparator<Bid> ASCENDING_TIME_THEN_PRICE = (left, right) -> {
        int i = Long.compare(left.dateTime, right.dateTime);
        if (i != 0) {
            return i;
        }
        return Double.compare(left.price, right.price);
    };
    @JsonProperty
    public final long auction;
    @JsonProperty
    public final long bidder;
    @JsonProperty
    public final long price;
    @JsonProperty
    public final long dateTime;
    @JsonProperty
    public final String extra;

    private Bid() {
        this.auction = 0L;
        this.bidder = 0L;
        this.price = 0L;
        this.dateTime = 0L;
        this.extra = null;
    }

    public Bid(long auction, long bidder, long price, long dateTime, String extra) {
        this.auction = auction;
        this.bidder = bidder;
        this.price = price;
        this.dateTime = dateTime;
        this.extra = extra;
    }

    public Bid withAnnotation(String annotation) {
        return new Bid(this.auction, this.bidder, this.price, this.dateTime, annotation + ": " + this.extra);
    }

    public boolean hasAnnotation(String annotation) {
        return this.extra.startsWith(annotation + ": ");
    }

    public Bid withoutAnnotation(String annotation) {
        if (this.hasAnnotation(annotation)) {
            return new Bid(this.auction, this.bidder, this.price, this.dateTime, this.extra.substring(annotation.length() + 2));
        }
        return this;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        Bid other = (Bid)otherObject;
        return Objects.equals(this.auction, other.auction) && Objects.equals(this.bidder, other.bidder) && Objects.equals(this.price, other.price) && Objects.equals(this.dateTime, other.dateTime) && Objects.equals(this.extra, other.extra);
    }

    public int hashCode() {
        return Objects.hash(this.auction, this.bidder, this.price, this.dateTime, this.extra);
    }

    @Override
    public long sizeInBytes() {
        return 32L + (long)this.extra.length() + 1L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

