/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class BidsPerSession
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    public static final Coder<BidsPerSession> CODER = new CustomCoder<BidsPerSession>(){

        public void encode(BidsPerSession value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.personId, outStream);
            LONG_CODER.encode((Object)value.bidsPerSession, outStream);
        }

        public BidsPerSession decode(InputStream inStream) throws CoderException, IOException {
            long personId = (Long)LONG_CODER.decode(inStream);
            long bidsPerSession = (Long)LONG_CODER.decode(inStream);
            return new BidsPerSession(personId, bidsPerSession);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(BidsPerSession v) {
            return v;
        }
    };
    @JsonProperty
    private final long personId;
    @JsonProperty
    private final long bidsPerSession;

    public BidsPerSession() {
        this.personId = 0L;
        this.bidsPerSession = 0L;
    }

    public BidsPerSession(long personId, long bidsPerSession) {
        this.personId = personId;
        this.bidsPerSession = bidsPerSession;
    }

    @Override
    public long sizeInBytes() {
        return 16L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BidsPerSession that = (BidsPerSession)o;
        return this.personId == that.personId && this.bidsPerSession == that.bidsPerSession;
    }

    public int hashCode() {
        return Objects.hashCode(this.personId, this.bidsPerSession);
    }
}

