/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class CategoryPrice
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    private static final Coder<Integer> INT_CODER = VarIntCoder.of();
    public static final Coder<CategoryPrice> CODER = new CustomCoder<CategoryPrice>(){

        public void encode(CategoryPrice value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.category, outStream);
            LONG_CODER.encode((Object)value.price, outStream);
            INT_CODER.encode((Object)(value.isLast ? 1 : 0), outStream);
        }

        public CategoryPrice decode(InputStream inStream) throws CoderException, IOException {
            long category = (Long)LONG_CODER.decode(inStream);
            long price = (Long)LONG_CODER.decode(inStream);
            boolean isLast = (Integer)INT_CODER.decode(inStream) != 0;
            return new CategoryPrice(category, price, isLast);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(CategoryPrice v) {
            return v;
        }
    };
    @JsonProperty
    public final long category;
    @JsonProperty
    public final long price;
    @JsonProperty
    public final boolean isLast;

    private CategoryPrice() {
        this.category = 0L;
        this.price = 0L;
        this.isLast = false;
    }

    public CategoryPrice(long category, long price, boolean isLast) {
        this.category = category;
        this.price = price;
        this.isLast = isLast;
    }

    @Override
    public long sizeInBytes() {
        return 17L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryPrice that = (CategoryPrice)o;
        return this.category == that.category && this.price == that.price && this.isLast == that.isLast;
    }

    public int hashCode() {
        return Objects.hashCode(this.category, this.price, this.isLast);
    }
}

