/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class Done
implements KnownSize,
Serializable {
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();
    public static final Coder<Done> CODER = new CustomCoder<Done>(){

        public void encode(Done value, OutputStream outStream) throws CoderException, IOException {
            STRING_CODER.encode((Object)value.message, outStream);
        }

        public Done decode(InputStream inStream) throws CoderException, IOException {
            String message = (String)STRING_CODER.decode(inStream);
            return new Done(message);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(Done v) {
            return v;
        }
    };
    @JsonProperty
    private final String message;

    public Done() {
        this.message = null;
    }

    public Done(String message) {
        this.message = message;
    }

    @Override
    public long sizeInBytes() {
        return this.message.length();
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Done done = (Done)o;
        return Objects.equal(this.message, done.message);
    }

    public int hashCode() {
        return Objects.hashCode(this.message);
    }
}

