/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.model.Person;

public class Event
implements KnownSize,
Serializable {
    private static final Coder<Integer> INT_CODER = VarIntCoder.of();
    public static final Coder<Event> CODER = new CustomCoder<Event>(){

        public void encode(Event value, OutputStream outStream) throws IOException {
            if (value.newPerson != null) {
                INT_CODER.encode((Object)Tag.PERSON.value, outStream);
                Person.CODER.encode((Object)value.newPerson, outStream);
            } else if (value.newAuction != null) {
                INT_CODER.encode((Object)Tag.AUCTION.value, outStream);
                Auction.CODER.encode((Object)value.newAuction, outStream);
            } else if (value.bid != null) {
                INT_CODER.encode((Object)Tag.BID.value, outStream);
                Bid.CODER.encode((Object)value.bid, outStream);
            } else {
                throw new RuntimeException("invalid event");
            }
        }

        public Event decode(InputStream inStream) throws IOException {
            int tag = (Integer)INT_CODER.decode(inStream);
            if (tag == Tag.PERSON.value) {
                Person person = (Person)Person.CODER.decode(inStream);
                return new Event(person);
            }
            if (tag == Tag.AUCTION.value) {
                Auction auction = (Auction)Auction.CODER.decode(inStream);
                return new Event(auction);
            }
            if (tag == Tag.BID.value) {
                Bid bid = (Bid)Bid.CODER.decode(inStream);
                return new Event(bid);
            }
            throw new RuntimeException("invalid event encoding");
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(Event v) {
            return v;
        }
    };
    @Nullable
    @org.apache.avro.reflect.Nullable
    public final Person newPerson;
    @Nullable
    @org.apache.avro.reflect.Nullable
    public final Auction newAuction;
    @Nullable
    @org.apache.avro.reflect.Nullable
    public final Bid bid;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equal(this.newPerson, event.newPerson) && Objects.equal(this.newAuction, event.newAuction) && Objects.equal(this.bid, event.bid);
    }

    public int hashCode() {
        return Objects.hashCode(this.newPerson, this.newAuction, this.bid);
    }

    private Event() {
        this.newPerson = null;
        this.newAuction = null;
        this.bid = null;
    }

    public Event(Person newPerson) {
        this.newPerson = newPerson;
        this.newAuction = null;
        this.bid = null;
    }

    public Event(Auction newAuction) {
        this.newPerson = null;
        this.newAuction = newAuction;
        this.bid = null;
    }

    public Event(Bid bid) {
        this.newPerson = null;
        this.newAuction = null;
        this.bid = bid;
    }

    public Event withAnnotation(String annotation) {
        if (this.newPerson != null) {
            return new Event(this.newPerson.withAnnotation(annotation));
        }
        if (this.newAuction != null) {
            return new Event(this.newAuction.withAnnotation(annotation));
        }
        return new Event(this.bid.withAnnotation(annotation));
    }

    public boolean hasAnnotation(String annotation) {
        if (this.newPerson != null) {
            return this.newPerson.hasAnnotation(annotation);
        }
        if (this.newAuction != null) {
            return this.newAuction.hasAnnotation(annotation);
        }
        return this.bid.hasAnnotation(annotation);
    }

    @Override
    public long sizeInBytes() {
        if (this.newPerson != null) {
            return 1L + this.newPerson.sizeInBytes();
        }
        if (this.newAuction != null) {
            return 1L + this.newAuction.sizeInBytes();
        }
        if (this.bid != null) {
            return 1L + this.bid.sizeInBytes();
        }
        throw new RuntimeException("invalid event");
    }

    public String toString() {
        if (this.newPerson != null) {
            return this.newPerson.toString();
        }
        if (this.newAuction != null) {
            return this.newAuction.toString();
        }
        if (this.bid != null) {
            return this.bid.toString();
        }
        throw new RuntimeException("invalid event");
    }

    private static enum Tag {
        PERSON(0),
        AUCTION(1),
        BID(2);

        private final int value;

        private Tag(int value) {
            this.value = value;
        }
    }
}

