/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class IdNameReserve
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();
    public static final Coder<IdNameReserve> CODER = new CustomCoder<IdNameReserve>(){

        public void encode(IdNameReserve value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.id, outStream);
            STRING_CODER.encode((Object)value.name, outStream);
            LONG_CODER.encode((Object)value.reserve, outStream);
        }

        public IdNameReserve decode(InputStream inStream) throws CoderException, IOException {
            long id = (Long)LONG_CODER.decode(inStream);
            String name = (String)STRING_CODER.decode(inStream);
            long reserve = (Long)LONG_CODER.decode(inStream);
            return new IdNameReserve(id, name, reserve);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(IdNameReserve v) {
            return v;
        }
    };
    @JsonProperty
    private final long id;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final long reserve;

    private IdNameReserve() {
        this.id = 0L;
        this.name = null;
        this.reserve = 0L;
    }

    public IdNameReserve(long id, String name, long reserve) {
        this.id = id;
        this.name = name;
        this.reserve = reserve;
    }

    @Override
    public long sizeInBytes() {
        return 8L + (long)this.name.length() + 1L + 8L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdNameReserve that = (IdNameReserve)o;
        return this.id == that.id && this.reserve == that.reserve && Objects.equal(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.reserve);
    }
}

