/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class NameCityStateId
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();
    public static final Coder<NameCityStateId> CODER = new CustomCoder<NameCityStateId>(){

        public void encode(NameCityStateId value, OutputStream outStream) throws CoderException, IOException {
            STRING_CODER.encode((Object)value.name, outStream);
            STRING_CODER.encode((Object)value.city, outStream);
            STRING_CODER.encode((Object)value.state, outStream);
            LONG_CODER.encode((Object)value.id, outStream);
        }

        public NameCityStateId decode(InputStream inStream) throws CoderException, IOException {
            String name = (String)STRING_CODER.decode(inStream);
            String city = (String)STRING_CODER.decode(inStream);
            String state = (String)STRING_CODER.decode(inStream);
            long id = (Long)LONG_CODER.decode(inStream);
            return new NameCityStateId(name, city, state, id);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(NameCityStateId v) {
            return v;
        }
    };
    @JsonProperty
    public final String name;
    @JsonProperty
    public final String city;
    @JsonProperty
    public final String state;
    @JsonProperty
    public final long id;

    private NameCityStateId() {
        this.name = null;
        this.city = null;
        this.state = null;
        this.id = 0L;
    }

    public NameCityStateId(String name, String city, String state, long id) {
        this.name = name;
        this.city = city;
        this.state = state;
        this.id = id;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        NameCityStateId other = (NameCityStateId)otherObject;
        return Objects.equals(this.name, other.name) && Objects.equals(this.city, other.city) && Objects.equals(this.state, other.state) && Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.city, this.state, this.id);
    }

    @Override
    public long sizeInBytes() {
        return (long)this.name.length() + 1L + (long)this.city.length() + 1L + (long)this.state.length() + 1L + 8L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

