/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class Person
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();
    public static final Coder<Person> CODER = new CustomCoder<Person>(){

        public void encode(Person value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.id, outStream);
            STRING_CODER.encode((Object)value.name, outStream);
            STRING_CODER.encode((Object)value.emailAddress, outStream);
            STRING_CODER.encode((Object)value.creditCard, outStream);
            STRING_CODER.encode((Object)value.city, outStream);
            STRING_CODER.encode((Object)value.state, outStream);
            LONG_CODER.encode((Object)value.dateTime, outStream);
            STRING_CODER.encode((Object)value.extra, outStream);
        }

        public Person decode(InputStream inStream) throws CoderException, IOException {
            long id = (Long)LONG_CODER.decode(inStream);
            String name = (String)STRING_CODER.decode(inStream);
            String emailAddress = (String)STRING_CODER.decode(inStream);
            String creditCard = (String)STRING_CODER.decode(inStream);
            String city = (String)STRING_CODER.decode(inStream);
            String state = (String)STRING_CODER.decode(inStream);
            long dateTime = (Long)LONG_CODER.decode(inStream);
            String extra = (String)STRING_CODER.decode(inStream);
            return new Person(id, name, emailAddress, creditCard, city, state, dateTime, extra);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(Person v) {
            return v;
        }
    };
    @JsonProperty
    public final long id;
    @JsonProperty
    public final String name;
    @JsonProperty
    public final String emailAddress;
    @JsonProperty
    public final String creditCard;
    @JsonProperty
    public final String city;
    @JsonProperty
    public final String state;
    @JsonProperty
    public final long dateTime;
    @JsonProperty
    public final String extra;

    private Person() {
        this.id = 0L;
        this.name = null;
        this.emailAddress = null;
        this.creditCard = null;
        this.city = null;
        this.state = null;
        this.dateTime = 0L;
        this.extra = null;
    }

    public Person(long id, String name, String emailAddress, String creditCard, String city, String state, long dateTime, String extra) {
        this.id = id;
        this.name = name;
        this.emailAddress = emailAddress;
        this.creditCard = creditCard;
        this.city = city;
        this.state = state;
        this.dateTime = dateTime;
        this.extra = extra;
    }

    public Person withAnnotation(String annotation) {
        return new Person(this.id, this.name, this.emailAddress, this.creditCard, this.city, this.state, this.dateTime, annotation + ": " + this.extra);
    }

    public boolean hasAnnotation(String annotation) {
        return this.extra.startsWith(annotation + ": ");
    }

    public Person withoutAnnotation(String annotation) {
        if (this.hasAnnotation(annotation)) {
            return new Person(this.id, this.name, this.emailAddress, this.creditCard, this.city, this.state, this.dateTime, this.extra.substring(annotation.length() + 2));
        }
        return this;
    }

    @Override
    public long sizeInBytes() {
        return 8L + (long)this.name.length() + 1L + (long)this.emailAddress.length() + 1L + (long)this.creditCard.length() + 1L + (long)this.city.length() + 1L + (long)this.state.length() + 8L + 1L + (long)this.extra.length() + 1L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        return this.id == person.id && this.dateTime == person.dateTime && Objects.equal(this.name, person.name) && Objects.equal(this.emailAddress, person.emailAddress) && Objects.equal(this.creditCard, person.creditCard) && Objects.equal(this.city, person.city) && Objects.equal(this.state, person.state) && Objects.equal(this.extra, person.extra);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.emailAddress, this.creditCard, this.city, this.state, this.dateTime, this.extra);
    }
}

