/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.KnownSize;

public class SellerPrice
implements KnownSize,
Serializable {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    public static final Coder<SellerPrice> CODER = new CustomCoder<SellerPrice>(){

        public void encode(SellerPrice value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.seller, outStream);
            LONG_CODER.encode((Object)value.price, outStream);
        }

        public SellerPrice decode(InputStream inStream) throws CoderException, IOException {
            long seller = (Long)LONG_CODER.decode(inStream);
            long price = (Long)LONG_CODER.decode(inStream);
            return new SellerPrice(seller, price);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public Object structuralValue(SellerPrice v) {
            return v;
        }
    };
    @JsonProperty
    public final long seller;
    @JsonProperty
    private final long price;

    private SellerPrice() {
        this.seller = 0L;
        this.price = 0L;
    }

    public SellerPrice(long seller, long price) {
        this.seller = seller;
        this.price = price;
    }

    @Override
    public long sizeInBytes() {
        return 16L;
    }

    public String toString() {
        try {
            return NexmarkUtils.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerPrice that = (SellerPrice)o;
        return this.seller == that.seller && this.price == that.price;
    }

    public int hashCode() {
        return Objects.hashCode(this.seller, this.price);
    }
}

