/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.Row;

public class RowSize
implements KnownSize {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    public static final Coder<RowSize> CODER = new CustomCoder<RowSize>(){

        public void encode(RowSize rowSize, OutputStream outStream) throws IOException {
            LONG_CODER.encode((Object)rowSize.sizeInBytes(), outStream);
        }

        public RowSize decode(InputStream inStream) throws IOException {
            return new RowSize((Long)LONG_CODER.decode(inStream));
        }
    };
    private long sizeInBytes;

    public static ParDo.SingleOutput<Row, RowSize> parDo() {
        return ParDo.of((DoFn)new DoFn<Row, RowSize>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)RowSize.of((Row)c.element()));
            }
        });
    }

    public static RowSize of(Row row) {
        return new RowSize(RowSize.sizeInBytes(row));
    }

    private static long sizeInBytes(Row row) {
        return RowCoder.estimatedSizeBytes((Row)row);
    }

    private RowSize(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }
}

