/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.model.sql;

import java.util.Map;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.model.sql.adapter.ModelAdaptersMapping;
import org.apache.beam.sdk.nexmark.model.sql.adapter.ModelFieldsAdapter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.Row;

public class ToRow {
    static final ToRow INSTANCE = new ToRow(ModelAdaptersMapping.ADAPTERS);
    private Map<Class, ModelFieldsAdapter> modelTypeAdapters;

    private ToRow(Map<Class, ModelFieldsAdapter> modelTypeAdapters) {
        this.modelTypeAdapters = modelTypeAdapters;
    }

    private Row toRow(Event event) {
        if (event == null) {
            return null;
        }
        KnownSize model = this.getModel(event);
        Class<?> modelClass = model.getClass();
        if (!this.modelTypeAdapters.containsKey(modelClass)) {
            throw new IllegalArgumentException("Beam SQL record type adapter is not registered for " + model.getClass().getSimpleName());
        }
        ModelFieldsAdapter adapter = this.modelTypeAdapters.get(modelClass);
        return Row.withSchema((Schema)adapter.getSchema()).addValues(adapter.getFieldsValues(model)).build();
    }

    private KnownSize getModel(Event event) {
        if (event.newAuction != null) {
            return event.newAuction;
        }
        if (event.newPerson != null) {
            return event.newPerson;
        }
        if (event.bid != null) {
            return event.bid;
        }
        throw new IllegalStateException("Unsupported event type " + event);
    }

    public static ParDo.SingleOutput<Event, Row> parDo() {
        return ParDo.of((DoFn)new DoFn<Event, Row>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Row row = INSTANCE.toRow((Event)c.element());
                c.output((Object)row);
            }
        });
    }
}

