/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.nexmark.Monitor;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.model.Person;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.joda.time.Instant;

public abstract class NexmarkQuery
extends PTransform<PCollection<Event>, PCollection<TimestampedValue<KnownSize>>> {
    public static final TupleTag<Auction> AUCTION_TAG = new TupleTag("auctions");
    public static final TupleTag<Bid> BID_TAG = new TupleTag("bids");
    static final TupleTag<Person> PERSON_TAG = new TupleTag("person");
    private static final SerializableFunction<Event, Boolean> IS_NEW_PERSON = (SerializableFunction & Serializable)event -> event.newPerson != null;
    private static final DoFn<Event, Person> AS_PERSON = new DoFn<Event, Person>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((Event)c.element()).newPerson);
        }
    };
    private static final SerializableFunction<Event, Boolean> IS_NEW_AUCTION = (SerializableFunction & Serializable)event -> event.newAuction != null;
    private static final DoFn<Event, Auction> AS_AUCTION = new DoFn<Event, Auction>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((Event)c.element()).newAuction);
        }
    };
    public static final SerializableFunction<Event, Boolean> IS_BID = (SerializableFunction & Serializable)event -> event.bid != null;
    private static final DoFn<Event, Bid> AS_BID = new DoFn<Event, Bid>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((Event)c.element()).bid);
        }
    };
    static final ParDo.SingleOutput<Person, KV<Long, Person>> PERSON_BY_ID = ParDo.of((DoFn)new DoFn<Person, KV<Long, Person>>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)KV.of((Object)((Person)c.element()).id, (Object)((Person)c.element())));
        }
    });
    static final ParDo.SingleOutput<Auction, KV<Long, Auction>> AUCTION_BY_ID = ParDo.of((DoFn)new DoFn<Auction, KV<Long, Auction>>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)KV.of((Object)((Auction)c.element()).id, (Object)((Auction)c.element())));
        }
    });
    static final ParDo.SingleOutput<Auction, KV<Long, Auction>> AUCTION_BY_SELLER = ParDo.of((DoFn)new DoFn<Auction, KV<Long, Auction>>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)KV.of((Object)((Auction)c.element()).seller, (Object)((Auction)c.element())));
        }
    });
    static final ParDo.SingleOutput<Bid, KV<Long, Bid>> BID_BY_AUCTION = ParDo.of((DoFn)new DoFn<Bid, KV<Long, Bid>>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)KV.of((Object)((Bid)c.element()).auction, (Object)((Bid)c.element())));
        }
    });
    static final ParDo.SingleOutput<Bid, Long> BID_TO_AUCTION = ParDo.of((DoFn)new DoFn<Bid, Long>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((Bid)c.element()).auction);
        }
    });
    static final ParDo.SingleOutput<Bid, Long> BID_TO_PRICE = ParDo.of((DoFn)new DoFn<Bid, Long>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((Bid)c.element()).price);
        }
    });
    public static final ParDo.SingleOutput<Event, Event> EVENT_TIMESTAMP_FROM_DATA = ParDo.of((DoFn)new DoFn<Event, Event>(){

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Event e = (Event)c.element();
            if (e.bid != null) {
                c.outputWithTimestamp((Object)e, new Instant(e.bid.dateTime));
            } else if (e.newPerson != null) {
                c.outputWithTimestamp((Object)e, new Instant(e.newPerson.dateTime));
            } else if (e.newAuction != null) {
                c.outputWithTimestamp((Object)e, new Instant(e.newAuction.dateTime));
            }
        }
    });
    public static final PTransform<PCollection<Event>, PCollection<Auction>> JUST_NEW_AUCTIONS = new PTransform<PCollection<Event>, PCollection<Auction>>("justNewAuctions"){

        public PCollection<Auction> expand(PCollection<Event> input) {
            return (PCollection)((PCollection)input.apply("IsNewAuction", (PTransform)Filter.by((SerializableFunction)IS_NEW_AUCTION))).apply("AsAuction", (PTransform)ParDo.of((DoFn)AS_AUCTION));
        }
    };
    public static final PTransform<PCollection<Event>, PCollection<Person>> JUST_NEW_PERSONS = new PTransform<PCollection<Event>, PCollection<Person>>("justNewPersons"){

        public PCollection<Person> expand(PCollection<Event> input) {
            return (PCollection)((PCollection)input.apply("IsNewPerson", (PTransform)Filter.by((SerializableFunction)IS_NEW_PERSON))).apply("AsPerson", (PTransform)ParDo.of((DoFn)AS_PERSON));
        }
    };
    public static final PTransform<PCollection<Event>, PCollection<Bid>> JUST_BIDS = new PTransform<PCollection<Event>, PCollection<Bid>>("justBids"){

        public PCollection<Bid> expand(PCollection<Event> input) {
            return (PCollection)((PCollection)input.apply("IsBid", (PTransform)Filter.by(IS_BID))).apply("AsBid", (PTransform)ParDo.of((DoFn)AS_BID));
        }
    };
    final NexmarkConfiguration configuration;
    public final Monitor<Event> eventMonitor;
    public final Monitor<KnownSize> resultMonitor;
    private final Monitor<Event> endOfStreamMonitor;
    private final Counter fatalCounter;

    protected NexmarkQuery(NexmarkConfiguration configuration, String name) {
        super(name);
        this.configuration = configuration;
        if (configuration.debug) {
            this.eventMonitor = new Monitor(name + ".Events", "event");
            this.resultMonitor = new Monitor(name + ".Results", "result");
            this.endOfStreamMonitor = new Monitor(name + ".EndOfStream", "end");
            this.fatalCounter = Metrics.counter((String)name, (String)"fatal");
        } else {
            this.eventMonitor = null;
            this.resultMonitor = null;
            this.endOfStreamMonitor = null;
            this.fatalCounter = null;
        }
    }

    protected abstract PCollection<KnownSize> applyPrim(PCollection<Event> var1);

    public PCollection<TimestampedValue<KnownSize>> expand(PCollection<Event> events) {
        if (this.configuration.debug) {
            events = (PCollection)((PCollection)events.apply(this.name + ".Monitor", this.eventMonitor.getTransform())).apply(this.name + ".Snoop", NexmarkUtils.snoop(this.name));
        }
        if (this.configuration.cpuDelayMs > 0L) {
            events = (PCollection)events.apply(this.name + ".CpuDelay", NexmarkUtils.cpuDelay(this.name, this.configuration.cpuDelayMs));
        }
        if (this.configuration.diskBusyBytes > 0L) {
            events = (PCollection)events.apply(this.name + ".DiskBusy", NexmarkUtils.diskBusy(this.configuration.diskBusyBytes));
        }
        PCollection queryResults = this.applyPrim(events);
        if (this.configuration.debug) {
            queryResults = (PCollection)queryResults.apply(this.name + ".Debug", this.resultMonitor.getTransform());
        }
        return (PCollection)queryResults.apply(this.name + ".Stamp", NexmarkUtils.stamp(this.name));
    }
}

