/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;

public abstract class NexmarkQueryModel
implements Serializable {
    public final NexmarkConfiguration configuration;

    NexmarkQueryModel(NexmarkConfiguration configuration) {
        this.configuration = configuration;
    }

    static Instant windowStart(Duration size, Duration period, Instant timestamp) {
        long ts = timestamp.getMillis();
        long p = period.getMillis();
        long lim = ts - ts % p;
        long s = size.getMillis();
        return new Instant(lim - s);
    }

    static <T> List<String> toValueTimestampOrder(Iterator<TimestampedValue<T>> itr) {
        ArrayList<String> strings = new ArrayList<String>();
        while (itr.hasNext()) {
            strings.add(itr.next().toString());
        }
        return strings;
    }

    static <T> List<String> toValueOrder(Iterator<TimestampedValue<T>> itr) {
        ArrayList<String> strings = new ArrayList<String>();
        while (itr.hasNext()) {
            strings.add(itr.next().getValue().toString());
        }
        return strings;
    }

    static <T> Set<String> toValue(Iterator<TimestampedValue<T>> itr) {
        HashSet<String> strings = new HashSet<String>();
        while (itr.hasNext()) {
            strings.add(itr.next().getValue().toString());
        }
        return strings;
    }

    public abstract AbstractSimulator<?, ?> simulator();

    Iterable<TimestampedValue<KnownSize>> relevantResults(Iterable<TimestampedValue<KnownSize>> results) {
        return results;
    }

    protected abstract <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> var1);

    public SerializableFunction<Iterable<TimestampedValue<KnownSize>>, Void> assertionFor() {
        final Collection<String> expectedStrings = this.toCollection(this.simulator().results());
        Assert.assertFalse((boolean)expectedStrings.isEmpty());
        return new SerializableFunction<Iterable<TimestampedValue<KnownSize>>, Void>(){

            @Nullable
            public Void apply(Iterable<TimestampedValue<KnownSize>> actual) {
                Collection<String> actualStrings = NexmarkQueryModel.this.toCollection(NexmarkQueryModel.this.relevantResults(actual).iterator());
                Assert.assertThat((String)"wrong pipeline output", actualStrings, (Matcher)IsEqual.equalTo((Object)expectedStrings));
                return null;
            }
        };
    }
}

