/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;

public class Query0
extends NexmarkQuery {
    public Query0(NexmarkConfiguration configuration) {
        super(configuration, "Query0");
    }

    private PCollection<Event> applyTyped(PCollection<Event> events) {
        final Coder coder = events.getCoder();
        return (PCollection)events.apply(this.name + ".Serialize", (PTransform)ParDo.of((DoFn)new DoFn<Event, Event>(){
            private final Counter bytesMetric;
            {
                this.bytesMetric = Metrics.counter((String)Query0.this.name, (String)"bytes");
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws CoderException, IOException {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                coder.encode((Object)((Event)c.element()), (OutputStream)outStream, Coder.Context.OUTER);
                byte[] byteArray = outStream.toByteArray();
                this.bytesMetric.inc((long)byteArray.length);
                ByteArrayInputStream inStream = new ByteArrayInputStream(byteArray);
                Event event = (Event)coder.decode((InputStream)inStream, Coder.Context.OUTER);
                c.output((Object)event);
            }
        }));
    }

    @Override
    protected PCollection<KnownSize> applyPrim(PCollection<Event> events) {
        return NexmarkUtils.castToKnownSize(this.name, this.applyTyped(events));
    }
}

