/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.BidsPerSession;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;

public class Query11
extends NexmarkQuery {
    public Query11(NexmarkConfiguration configuration) {
        super(configuration, "Query11");
    }

    private PCollection<BidsPerSession> applyTyped(PCollection<Event> events) {
        PCollection bidders = (PCollection)((PCollection)events.apply(JUST_BIDS)).apply(this.name + ".Rekey", (PTransform)ParDo.of((DoFn)new DoFn<Bid, Long>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Bid bid = (Bid)c.element();
                c.output((Object)bid.bidder);
            }
        }));
        PCollection biddersWindowed = (PCollection)bidders.apply((PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.standardSeconds((long)this.configuration.windowSizeSec))).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)this.configuration.maxLogEvents))).discardingFiredPanes().withAllowedLateness(Duration.standardSeconds((long)(this.configuration.occasionalDelaySec / 2L))));
        return (PCollection)((PCollection)biddersWindowed.apply(Count.perElement())).apply(this.name + ".ToResult", (PTransform)ParDo.of((DoFn)new DoFn<KV<Long, Long>, BidsPerSession>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)new BidsPerSession((Long)((KV)c.element()).getKey(), (Long)((KV)c.element()).getValue()));
            }
        }));
    }

    @Override
    protected PCollection<KnownSize> applyPrim(PCollection<Event> events) {
        return NexmarkUtils.castToKnownSize(this.name, this.applyTyped(events));
    }
}

