/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Instant;

public class Query1Model
extends NexmarkQueryModel
implements Serializable {
    public Query1Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query1Model.toValueTimestampOrder(itr);
    }

    private static class Simulator
    extends AbstractSimulator<Event, Bid> {
        public Simulator(NexmarkConfiguration configuration) {
            super(NexmarkUtils.standardEventIterator(configuration));
        }

        @Override
        protected void run() {
            TimestampedValue timestampedEvent = this.nextInput();
            if (timestampedEvent == null) {
                this.allDone();
                return;
            }
            Event event = (Event)timestampedEvent.getValue();
            if (event.bid == null) {
                return;
            }
            Bid bid = event.bid;
            Bid resultBid = new Bid(bid.auction, bid.bidder, bid.price * 89L / 100L, bid.dateTime, bid.extra);
            TimestampedValue result = TimestampedValue.of((Object)resultBid, (Instant)timestampedEvent.getTimestamp());
            this.addResult(result);
        }
    }
}

