/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.AuctionPrice;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Instant;

public class Query2Model
extends NexmarkQueryModel
implements Serializable {
    public Query2Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query2Model.toValueTimestampOrder(itr);
    }

    private class Simulator
    extends AbstractSimulator<Event, AuctionPrice> {
        public Simulator(NexmarkConfiguration configuration) {
            super(NexmarkUtils.standardEventIterator(configuration));
        }

        @Override
        protected void run() {
            TimestampedValue timestampedEvent = this.nextInput();
            if (timestampedEvent == null) {
                this.allDone();
                return;
            }
            Event event = (Event)timestampedEvent.getValue();
            if (event.bid == null) {
                return;
            }
            Bid bid = event.bid;
            if (bid.auction % (long)Query2Model.this.configuration.auctionSkip != 0L) {
                return;
            }
            AuctionPrice auctionPrice = new AuctionPrice(bid.auction, bid.price);
            TimestampedValue result = TimestampedValue.of((Object)auctionPrice, (Instant)timestampedEvent.getTimestamp());
            this.addResult(result);
        }
    }
}

