/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.collect.Multimap;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.NameCityStateId;
import org.apache.beam.sdk.nexmark.model.Person;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Instant;

public class Query3Model
extends NexmarkQueryModel
implements Serializable {
    public Query3Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query3Model.toValue(itr);
    }

    private static class Simulator
    extends AbstractSimulator<Event, NameCityStateId> {
        private final Multimap<Long, Auction> newAuctions;
        private final Map<Long, Person> newPersons = new HashMap<Long, Person>();

        public Simulator(NexmarkConfiguration configuration) {
            super(NexmarkUtils.standardEventIterator(configuration));
            this.newAuctions = ArrayListMultimap.create();
        }

        private void addResult(Auction auction, Person person, Instant timestamp) {
            TimestampedValue result = TimestampedValue.of((Object)new NameCityStateId(person.name, person.city, person.state, auction.id), (Instant)timestamp);
            this.addResult(result);
        }

        @Override
        protected void run() {
            TimestampedValue timestampedEvent = this.nextInput();
            if (timestampedEvent == null) {
                this.allDone();
                return;
            }
            Event event = (Event)timestampedEvent.getValue();
            if (event.bid != null) {
                return;
            }
            Instant timestamp = timestampedEvent.getTimestamp();
            if (event.newAuction != null) {
                if (event.newAuction.category == 10L) {
                    Person person = this.newPersons.get(event.newAuction.seller);
                    if (person != null) {
                        this.addResult(event.newAuction, person, timestamp);
                    } else {
                        this.newAuctions.put(event.newAuction.seller, event.newAuction);
                    }
                }
            } else if ("OR".equals(event.newPerson.state) || "ID".equals(event.newPerson.state) || "CA".equals(event.newPerson.state)) {
                for (Auction auction : this.newAuctions.get(event.newPerson.id)) {
                    this.addResult(auction, event.newPerson, timestamp);
                }
                this.newAuctions.removeAll(event.newPerson.id);
                this.newPersons.put(event.newPerson.id, event.newPerson);
            }
        }
    }
}

