/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import org.apache.beam.sdk.nexmark.Monitor;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.AuctionBid;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.CategoryPrice;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.queries.AuctionOrBid;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.nexmark.queries.WinningBids;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.Mean;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;

public class Query4
extends NexmarkQuery {
    private final Monitor<AuctionBid> winningBidsMonitor;

    public Query4(NexmarkConfiguration configuration) {
        super(configuration, "Query4");
        this.winningBidsMonitor = new Monitor(this.name + ".WinningBids", "winning");
    }

    private PCollection<CategoryPrice> applyTyped(PCollection<Event> events) {
        PCollection winningBids = (PCollection)((PCollection)events.apply((PTransform)Filter.by((SerializableFunction)new AuctionOrBid()))).apply((PTransform)new WinningBids(this.name + ".WinningBids", this.configuration));
        winningBids = (PCollection)winningBids.apply(this.name + ".WinningBidsMonitor", this.winningBidsMonitor.getTransform());
        return (PCollection)((PCollection)((PCollection)((PCollection)winningBids.apply(this.name + ".Rekey", (PTransform)ParDo.of((DoFn)new DoFn<AuctionBid, KV<Long, Long>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Auction auction = ((AuctionBid)c.element()).auction;
                Bid bid = ((AuctionBid)c.element()).bid;
                c.output((Object)KV.of((Object)auction.category, (Object)bid.price));
            }
        }))).apply((PTransform)Window.into((WindowFn)SlidingWindows.of((Duration)Duration.standardSeconds((long)this.configuration.windowSizeSec)).every(Duration.standardSeconds((long)this.configuration.windowPeriodSec))))).apply((PTransform)Mean.perKey().withHotKeyFanout(this.configuration.fanout))).apply(this.name + ".Project", (PTransform)ParDo.of((DoFn)new DoFn<KV<Long, Double>, CategoryPrice>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)new CategoryPrice((Long)((KV)c.element()).getKey(), Math.round((Double)((KV)c.element()).getValue()), c.pane().isLast()));
            }
        }));
    }

    @Override
    protected PCollection<KnownSize> applyPrim(PCollection<Event> events) {
        return NexmarkUtils.castToKnownSize(this.name, this.applyTyped(events));
    }
}

