/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.AuctionBid;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.CategoryPrice;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.nexmark.queries.WinningBidsSimulator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.junit.Assert;

public class Query4Model
extends NexmarkQueryModel
implements Serializable {
    public Query4Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected Iterable<TimestampedValue<KnownSize>> relevantResults(Iterable<TimestampedValue<KnownSize>> results) {
        TreeMap<Long, TimestampedValue> finalAverages = new TreeMap<Long, TimestampedValue>();
        for (TimestampedValue<KnownSize> obj : results) {
            Assert.assertTrue((String)"have CategoryPrice", (boolean)(obj.getValue() instanceof CategoryPrice));
            CategoryPrice categoryPrice = (CategoryPrice)obj.getValue();
            if (!categoryPrice.isLast) continue;
            finalAverages.put(categoryPrice.category, TimestampedValue.of((Object)categoryPrice, (Instant)obj.getTimestamp()));
        }
        return finalAverages.values();
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query4Model.toValue(itr);
    }

    private class Simulator
    extends AbstractSimulator<AuctionBid, CategoryPrice> {
        private final List<TimestampedValue<CategoryPrice>> winningPricesByCategory;
        private Instant lastTimestamp;
        private Instant windowStart;
        private final Map<Long, TimestampedValue<CategoryPrice>> lastSeenResults;

        public Simulator(NexmarkConfiguration configuration) {
            super(new WinningBidsSimulator(configuration).results());
            this.winningPricesByCategory = new ArrayList<TimestampedValue<CategoryPrice>>();
            this.lastTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;
            this.windowStart = NexmarkUtils.BEGINNING_OF_TIME;
            this.lastSeenResults = new TreeMap<Long, TimestampedValue<CategoryPrice>>();
        }

        private void averages(Instant end) {
            long category;
            TreeMap<Long, Long> counts = new TreeMap<Long, Long>();
            TreeMap<Long, Long> totals = new TreeMap<Long, Long>();
            for (TimestampedValue<CategoryPrice> timestampedValue : this.winningPricesByCategory) {
                if (!timestampedValue.getTimestamp().isBefore((ReadableInstant)end)) continue;
                category = ((CategoryPrice)timestampedValue.getValue()).category;
                long price = ((CategoryPrice)timestampedValue.getValue()).price;
                Long count = (Long)counts.get(category);
                count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
                counts.put(category, count);
                Long total = (Long)totals.get(category);
                total = total == null ? Long.valueOf(price) : Long.valueOf(total + price);
                totals.put(category, total);
            }
            for (Map.Entry entry : counts.entrySet()) {
                category = (Long)entry.getKey();
                long count = (Long)entry.getValue();
                long total = (Long)totals.get(category);
                TimestampedValue result = TimestampedValue.of((Object)new CategoryPrice(category, Math.round((double)total / (double)count), true), (Instant)this.lastTimestamp);
                this.addIntermediateResult(result);
                this.lastSeenResults.put(category, (TimestampedValue<CategoryPrice>)result);
            }
        }

        private void prune(Instant newWindowStart) {
            while (!newWindowStart.equals((Object)this.windowStart)) {
                this.averages(this.windowStart.plus((ReadableDuration)Duration.standardSeconds((long)Query4Model.this.configuration.windowSizeSec)));
                this.windowStart = this.windowStart.plus((ReadableDuration)Duration.standardSeconds((long)Query4Model.this.configuration.windowPeriodSec));
                this.winningPricesByCategory.removeIf(categoryPriceTimestampedValue -> categoryPriceTimestampedValue.getTimestamp().isBefore((ReadableInstant)this.windowStart));
                if (!this.winningPricesByCategory.isEmpty()) continue;
                this.windowStart = newWindowStart;
            }
        }

        private void captureWinningBid(Auction auction, Bid bid, Instant timestamp) {
            this.winningPricesByCategory.add((TimestampedValue<CategoryPrice>)TimestampedValue.of((Object)new CategoryPrice(auction.category, bid.price, false), (Instant)timestamp));
        }

        @Override
        protected void run() {
            TimestampedValue timestampedWinningBid = this.nextInput();
            if (timestampedWinningBid == null) {
                this.prune(NexmarkUtils.END_OF_TIME);
                for (TimestampedValue<CategoryPrice> result : this.lastSeenResults.values()) {
                    this.addResult(result);
                }
                this.allDone();
                return;
            }
            this.lastTimestamp = timestampedWinningBid.getTimestamp();
            Instant newWindowStart = NexmarkQueryModel.windowStart(Duration.standardSeconds((long)Query4Model.this.configuration.windowSizeSec), Duration.standardSeconds((long)Query4Model.this.configuration.windowPeriodSec), this.lastTimestamp);
            this.prune(newWindowStart);
            this.captureWinningBid(((AuctionBid)timestampedWinningBid.getValue()).auction, ((AuctionBid)timestampedWinningBid.getValue()).bid, this.lastTimestamp);
        }
    }
}

