/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.AuctionCount;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;

public class Query5
extends NexmarkQuery {
    public Query5(NexmarkConfiguration configuration) {
        super(configuration, "Query5");
    }

    private PCollection<AuctionCount> applyTyped(PCollection<Event> events) {
        return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)events.apply(JUST_BIDS)).apply((PTransform)Window.into((WindowFn)SlidingWindows.of((Duration)Duration.standardSeconds((long)this.configuration.windowSizeSec)).every(Duration.standardSeconds((long)this.configuration.windowPeriodSec))))).apply("BidToAuction", (PTransform)BID_TO_AUCTION)).apply(Count.perElement())).apply(this.name + ".ToSingletons", (PTransform)ParDo.of((DoFn)new DoFn<KV<Long, Long>, KV<List<Long>, Long>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of(Collections.singletonList((Long)((KV)c.element()).getKey()), (Object)((Long)((KV)c.element()).getValue())));
            }
        }))).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new Combine.BinaryCombineFn<KV<List<Long>, Long>>(){

            public KV<List<Long>, Long> apply(KV<List<Long>, Long> left, KV<List<Long>, Long> right) {
                List leftBestAuctions = (List)left.getKey();
                long leftCount = (Long)left.getValue();
                List rightBestAuctions = (List)right.getKey();
                long rightCount = (Long)right.getValue();
                if (leftCount > rightCount) {
                    return left;
                }
                if (leftCount < rightCount) {
                    return right;
                }
                ArrayList newBestAuctions = new ArrayList();
                newBestAuctions.addAll(leftBestAuctions);
                newBestAuctions.addAll(rightBestAuctions);
                return KV.of(newBestAuctions, (Object)leftCount);
            }
        }).withoutDefaults().withFanout(this.configuration.fanout))).apply(this.name + ".Select", (PTransform)ParDo.of((DoFn)new DoFn<KV<List<Long>, Long>, AuctionCount>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                long count = (Long)((KV)c.element()).getValue();
                Iterator iterator = ((List)((KV)c.element()).getKey()).iterator();
                while (iterator.hasNext()) {
                    long auction = (Long)iterator.next();
                    c.output((Object)new AuctionCount(auction, count));
                }
            }
        }));
    }

    @Override
    protected PCollection<KnownSize> applyPrim(PCollection<Event> events) {
        return NexmarkUtils.castToKnownSize(this.name, this.applyTyped(events));
    }
}

