/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.AuctionCount;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class Query5Model
extends NexmarkQueryModel
implements Serializable {
    public Query5Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query5Model.toValue(itr);
    }

    private class Simulator
    extends AbstractSimulator<Event, AuctionCount> {
        private final Map<Long, List<Instant>> bids;
        private Instant windowStart;

        public Simulator(NexmarkConfiguration configuration) {
            super(NexmarkUtils.standardEventIterator(configuration));
            this.bids = new TreeMap<Long, List<Instant>>();
            this.windowStart = NexmarkUtils.BEGINNING_OF_TIME;
        }

        private void countBids(Instant end) {
            TreeMap<Long, Long> counts = new TreeMap<Long, Long>();
            long maxCount = 0L;
            for (Map.Entry<Long, List<Instant>> entry : this.bids.entrySet()) {
                long count = 0L;
                long auction = entry.getKey();
                for (Instant instant : entry.getValue()) {
                    if (!instant.isBefore((ReadableInstant)end)) continue;
                    ++count;
                }
                if (count <= 0L) continue;
                counts.put(auction, count);
                maxCount = Math.max(maxCount, count);
            }
            for (Map.Entry<Long, List<Object>> entry : counts.entrySet()) {
                long auction = entry.getKey();
                long count = (Long)((Object)entry.getValue());
                if (count != maxCount) continue;
                AuctionCount result = new AuctionCount(auction, count);
                this.addResult(TimestampedValue.of((Object)result, (Instant)end));
            }
        }

        private boolean retireBids(Instant cutoff) {
            boolean anyRemain = false;
            for (Map.Entry<Long, List<Instant>> entry : this.bids.entrySet()) {
                long auction = entry.getKey();
                Iterator<Instant> itr = entry.getValue().iterator();
                while (itr.hasNext()) {
                    Instant bid = itr.next();
                    if (bid.isBefore((ReadableInstant)cutoff)) {
                        NexmarkUtils.info("retire: %s for %s", bid, auction);
                        itr.remove();
                        continue;
                    }
                    anyRemain = true;
                }
            }
            return anyRemain;
        }

        private void retireWindows(Instant newWindowStart) {
            while (!newWindowStart.equals((Object)this.windowStart)) {
                NexmarkUtils.info("retiring window %s, aiming for %s", this.windowStart, newWindowStart);
                this.countBids(this.windowStart.plus((ReadableDuration)Duration.standardSeconds((long)Query5Model.this.configuration.windowSizeSec)));
                this.windowStart = this.windowStart.plus((ReadableDuration)Duration.standardSeconds((long)Query5Model.this.configuration.windowPeriodSec));
                if (this.retireBids(this.windowStart)) continue;
                this.windowStart = newWindowStart;
            }
        }

        private void captureBid(Bid bid, Instant timestamp) {
            List existing = this.bids.computeIfAbsent(bid.auction, k -> new ArrayList());
            existing.add(timestamp);
        }

        @Override
        public void run() {
            TimestampedValue timestampedEvent = this.nextInput();
            if (timestampedEvent == null) {
                this.retireWindows(NexmarkUtils.END_OF_TIME);
                this.allDone();
                return;
            }
            Event event = (Event)timestampedEvent.getValue();
            if (event.bid == null) {
                return;
            }
            Instant timestamp = timestampedEvent.getTimestamp();
            Instant newWindowStart = NexmarkQueryModel.windowStart(Duration.standardSeconds((long)Query5Model.this.configuration.windowSizeSec), Duration.standardSeconds((long)Query5Model.this.configuration.windowPeriodSec), timestamp);
            this.retireWindows(newWindowStart);
            this.captureBid(event.bid, timestamp);
        }
    }
}

