/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.collect.Lists;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.AuctionBid;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.model.SellerPrice;
import org.apache.beam.sdk.nexmark.queries.AuctionOrBid;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.nexmark.queries.WinningBids;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;

public class Query6
extends NexmarkQuery {
    public Query6(NexmarkConfiguration configuration) {
        super(configuration, "Query6");
    }

    private PCollection<SellerPrice> applyTyped(PCollection<Event> events) {
        return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)events.apply((PTransform)Filter.by((SerializableFunction)new AuctionOrBid()))).apply((PTransform)new WinningBids(this.name + ".WinningBids", this.configuration))).apply(this.name + ".Rekey", (PTransform)ParDo.of((DoFn)new DoFn<AuctionBid, KV<Long, Bid>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Auction auction = ((AuctionBid)c.element()).auction;
                Bid bid = ((AuctionBid)c.element()).bid;
                c.output((Object)KV.of((Object)auction.seller, (Object)bid));
            }
        }))).apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).accumulatingFiredPanes().withAllowedLateness(Duration.ZERO))).apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new MovingMeanSellingPrice(10)))).apply(this.name + ".Select", (PTransform)ParDo.of((DoFn)new DoFn<KV<Long, Long>, SellerPrice>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)new SellerPrice((Long)((KV)c.element()).getKey(), (Long)((KV)c.element()).getValue()));
            }
        }));
    }

    @Override
    protected PCollection<KnownSize> applyPrim(PCollection<Event> events) {
        return NexmarkUtils.castToKnownSize(this.name, this.applyTyped(events));
    }

    private static class MovingMeanSellingPrice
    extends Combine.CombineFn<Bid, List<Bid>, Long> {
        private final int maxNumBids;

        public MovingMeanSellingPrice(int maxNumBids) {
            this.maxNumBids = maxNumBids;
        }

        public List<Bid> createAccumulator() {
            return new ArrayList<Bid>();
        }

        public List<Bid> addInput(List<Bid> accumulator, Bid input) {
            accumulator.add(input);
            accumulator.sort(Bid.ASCENDING_TIME_THEN_PRICE);
            if (accumulator.size() > this.maxNumBids) {
                accumulator.remove(0);
            }
            return accumulator;
        }

        public List<Bid> mergeAccumulators(Iterable<List<Bid>> accumulators) {
            ArrayList<Bid> result = new ArrayList<Bid>();
            for (List<Bid> accumulator : accumulators) {
                result.addAll(accumulator);
            }
            result.sort(Bid.ASCENDING_TIME_THEN_PRICE);
            if (result.size() > this.maxNumBids) {
                result = Lists.newArrayList(result.listIterator(result.size() - this.maxNumBids));
            }
            return result;
        }

        public Long extractOutput(List<Bid> accumulator) {
            if (accumulator.isEmpty()) {
                return 0L;
            }
            long sumOfPrice = 0L;
            for (Bid bid : accumulator) {
                sumOfPrice += bid.price;
            }
            return Math.round((double)sumOfPrice / (double)accumulator.size());
        }
    }
}

