/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.AuctionBid;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.model.SellerPrice;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.nexmark.queries.WinningBidsSimulator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Instant;
import org.junit.Assert;

public class Query6Model
extends NexmarkQueryModel
implements Serializable {
    public Query6Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected Iterable<TimestampedValue<KnownSize>> relevantResults(Iterable<TimestampedValue<KnownSize>> results) {
        TreeMap<Long, TimestampedValue> finalAverages = new TreeMap<Long, TimestampedValue>();
        for (TimestampedValue<KnownSize> obj : results) {
            Assert.assertTrue((String)"have SellerPrice", (boolean)(obj.getValue() instanceof SellerPrice));
            SellerPrice sellerPrice = (SellerPrice)obj.getValue();
            finalAverages.put(sellerPrice.seller, TimestampedValue.of((Object)sellerPrice, (Instant)obj.getTimestamp()));
        }
        return finalAverages.values();
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query6Model.toValue(itr);
    }

    private static class Simulator
    extends AbstractSimulator<AuctionBid, SellerPrice> {
        private final Map<Long, Queue<Bid>> winningBidsPerSeller = new TreeMap<Long, Queue<Bid>>();
        private final Map<Long, Long> totalWinningBidPricesPerSeller = new TreeMap<Long, Long>();
        private Instant lastTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;

        public Simulator(NexmarkConfiguration configuration) {
            super(new WinningBidsSimulator(configuration).results());
        }

        private void captureWinningBid(Auction auction, Bid bid, Instant timestamp) {
            int count;
            Long total;
            NexmarkUtils.info("winning auction, bid: %s, %s", auction, bid);
            Queue<Bid> queue = this.winningBidsPerSeller.get(auction.seller);
            if (queue == null) {
                queue = new PriorityQueue<Bid>(10, (b1, b2) -> Long.compare(b1.dateTime, b2.dateTime));
            }
            if ((total = this.totalWinningBidPricesPerSeller.get(auction.seller)) == null) {
                total = 0L;
            }
            if ((count = queue.size()) == 10) {
                total = total - queue.remove().price;
            } else {
                ++count;
            }
            queue.add(bid);
            total = total + bid.price;
            this.winningBidsPerSeller.put(auction.seller, queue);
            this.totalWinningBidPricesPerSeller.put(auction.seller, total);
            TimestampedValue intermediateResult = TimestampedValue.of((Object)new SellerPrice(auction.seller, Math.round((double)total.longValue() / (double)count)), (Instant)timestamp);
            this.addIntermediateResult(intermediateResult);
        }

        @Override
        protected void run() {
            TimestampedValue timestampedWinningBid = this.nextInput();
            if (timestampedWinningBid == null) {
                for (Map.Entry<Long, Queue<Bid>> entry : this.winningBidsPerSeller.entrySet()) {
                    long seller = entry.getKey();
                    long count = entry.getValue().size();
                    long total = this.totalWinningBidPricesPerSeller.get(seller);
                    this.addResult(TimestampedValue.of((Object)new SellerPrice(seller, Math.round((double)total / (double)count)), (Instant)this.lastTimestamp));
                }
                this.allDone();
                return;
            }
            this.lastTimestamp = timestampedWinningBid.getTimestamp();
            this.captureWinningBid(((AuctionBid)timestampedWinningBid.getValue()).auction, ((AuctionBid)timestampedWinningBid.getValue()).bid, this.lastTimestamp);
        }
    }
}

