/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.joda.time.Duration;

public class Query7
extends NexmarkQuery {
    public Query7(NexmarkConfiguration configuration) {
        super(configuration, "Query7");
    }

    private PCollection<Bid> applyTyped(PCollection<Event> events) {
        PCollection slidingBids = (PCollection)((PCollection)events.apply(JUST_BIDS)).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)this.configuration.windowSizeSec))));
        final PCollectionView maxPriceView = (PCollectionView)((PCollection)slidingBids.apply("BidToPrice", (PTransform)BID_TO_PRICE)).apply((PTransform)Max.longsGlobally().withFanout(this.configuration.fanout).asSingletonView());
        return (PCollection)slidingBids.apply(this.name + ".Select", (PTransform)ParDo.of((DoFn)new DoFn<Bid, Bid>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                long maxPrice = (Long)c.sideInput(maxPriceView);
                Bid bid = (Bid)c.element();
                if (bid.price == maxPrice) {
                    c.output((Object)bid);
                }
            }
        }).withSideInputs(new PCollectionView[]{maxPriceView}));
    }

    @Override
    protected PCollection<KnownSize> applyPrim(PCollection<Event> events) {
        return NexmarkUtils.castToKnownSize(this.name, this.applyTyped(events));
    }
}

