/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class Query7Model
extends NexmarkQueryModel
implements Serializable {
    public Query7Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query7Model.toValueOrder(itr);
    }

    private class Simulator
    extends AbstractSimulator<Event, Bid> {
        private final List<Bid> highestBids;
        private Instant windowStart;
        private Instant lastTimestamp;

        public Simulator(NexmarkConfiguration configuration) {
            super(NexmarkUtils.standardEventIterator(configuration));
            this.highestBids = new ArrayList<Bid>();
            this.windowStart = NexmarkUtils.BEGINNING_OF_TIME;
            this.lastTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;
        }

        private void retireWindow(Instant timestamp) {
            for (Bid bid : this.highestBids) {
                this.addResult(TimestampedValue.of((Object)bid, (Instant)timestamp));
            }
            this.highestBids.clear();
        }

        private void captureBid(Bid bid) {
            Iterator<Bid> itr = this.highestBids.iterator();
            boolean isWinning = true;
            while (itr.hasNext()) {
                Bid existingBid = itr.next();
                if (existingBid.price > bid.price) {
                    isWinning = false;
                    break;
                }
                NexmarkUtils.info("smaller price: %s", existingBid);
                itr.remove();
            }
            if (isWinning) {
                NexmarkUtils.info("larger price: %s", bid);
                this.highestBids.add(bid);
            }
        }

        @Override
        protected void run() {
            TimestampedValue timestampedEvent = this.nextInput();
            if (timestampedEvent == null) {
                this.retireWindow(this.lastTimestamp);
                this.allDone();
                return;
            }
            Event event = (Event)timestampedEvent.getValue();
            if (event.bid == null) {
                return;
            }
            this.lastTimestamp = timestampedEvent.getTimestamp();
            Instant newWindowStart = NexmarkQueryModel.windowStart(Duration.standardSeconds((long)Query7Model.this.configuration.windowSizeSec), Duration.standardSeconds((long)Query7Model.this.configuration.windowSizeSec), this.lastTimestamp);
            if (!newWindowStart.equals((Object)this.windowStart)) {
                this.retireWindow(this.lastTimestamp);
                this.windowStart = newWindowStart;
            }
            this.captureBid(event.bid);
        }
    }
}

