/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.IdNameReserve;
import org.apache.beam.sdk.nexmark.model.KnownSize;
import org.apache.beam.sdk.nexmark.model.Person;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.joda.time.Duration;

public class Query8
extends NexmarkQuery {
    public Query8(NexmarkConfiguration configuration) {
        super(configuration, "Query8");
    }

    private PCollection<IdNameReserve> applyTyped(PCollection<Event> events) {
        PCollection personsById = (PCollection)((PCollection)((PCollection)events.apply(JUST_NEW_PERSONS)).apply("Query8.WindowPersons", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)this.configuration.windowSizeSec))))).apply("PersonById", (PTransform)PERSON_BY_ID);
        PCollection auctionsBySeller = (PCollection)((PCollection)((PCollection)events.apply(JUST_NEW_AUCTIONS)).apply("Query8.WindowAuctions", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)this.configuration.windowSizeSec))))).apply("AuctionBySeller", (PTransform)AUCTION_BY_SELLER);
        return (PCollection)((PCollection)KeyedPCollectionTuple.of((TupleTag)PERSON_TAG, (PCollection)personsById).and(AUCTION_TAG, auctionsBySeller).apply((PTransform)CoGroupByKey.create())).apply(this.name + ".Select", (PTransform)ParDo.of((DoFn)new DoFn<KV<Long, CoGbkResult>, IdNameReserve>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Person person = (Person)((CoGbkResult)((KV)c.element()).getValue()).getOnly(NexmarkQuery.PERSON_TAG, null);
                if (person == null) {
                    return;
                }
                for (Auction auction : ((CoGbkResult)((KV)c.element()).getValue()).getAll(NexmarkQuery.AUCTION_TAG)) {
                    c.output((Object)new IdNameReserve(person.id, person.name, auction.reserve));
                }
            }
        }));
    }

    @Override
    protected PCollection<KnownSize> applyPrim(PCollection<Event> events) {
        return NexmarkUtils.castToKnownSize(this.name, this.applyTyped(events));
    }
}

