/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.collect.Multimap;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.NexmarkUtils;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.IdNameReserve;
import org.apache.beam.sdk.nexmark.model.Person;
import org.apache.beam.sdk.nexmark.queries.AbstractSimulator;
import org.apache.beam.sdk.nexmark.queries.NexmarkQueryModel;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class Query8Model
extends NexmarkQueryModel
implements Serializable {
    public Query8Model(NexmarkConfiguration configuration) {
        super(configuration);
    }

    @Override
    public AbstractSimulator<?, ?> simulator() {
        return new Simulator(this.configuration);
    }

    @Override
    protected <T> Collection<String> toCollection(Iterator<TimestampedValue<T>> itr) {
        return Query8Model.toValue(itr);
    }

    private class Simulator
    extends AbstractSimulator<Event, IdNameReserve> {
        private final Map<Long, Person> newPersons;
        private final Multimap<Long, Auction> newAuctions;
        private Instant windowStart;

        public Simulator(NexmarkConfiguration configuration) {
            super(NexmarkUtils.standardEventIterator(configuration));
            this.newPersons = new HashMap<Long, Person>();
            this.newAuctions = ArrayListMultimap.create();
            this.windowStart = NexmarkUtils.BEGINNING_OF_TIME;
        }

        private void retirePersons() {
            for (Map.Entry<Long, Person> entry : this.newPersons.entrySet()) {
                NexmarkUtils.info("retire: %s", entry.getValue());
            }
            this.newPersons.clear();
        }

        private void retireAuctions() {
            for (Map.Entry<Long, Auction> entry : this.newAuctions.entries()) {
                NexmarkUtils.info("retire: %s", entry.getValue());
            }
            this.newAuctions.clear();
        }

        private void addResult(Auction auction, Person person, Instant timestamp) {
            this.addResult(TimestampedValue.of((Object)new IdNameReserve(person.id, person.name, auction.reserve), (Instant)timestamp));
        }

        @Override
        public void run() {
            TimestampedValue timestampedEvent = this.nextInput();
            if (timestampedEvent == null) {
                this.allDone();
                return;
            }
            Event event = (Event)timestampedEvent.getValue();
            if (event.bid != null) {
                return;
            }
            Instant timestamp = timestampedEvent.getTimestamp();
            Instant newWindowStart = NexmarkQueryModel.windowStart(Duration.standardSeconds((long)Query8Model.this.configuration.windowSizeSec), Duration.standardSeconds((long)Query8Model.this.configuration.windowSizeSec), timestamp);
            if (!newWindowStart.equals((Object)this.windowStart)) {
                this.retirePersons();
                this.retireAuctions();
                this.windowStart = newWindowStart;
            }
            if (event.newAuction != null) {
                Person person = this.newPersons.get(event.newAuction.seller);
                if (person != null) {
                    this.addResult(event.newAuction, person, timestamp);
                } else {
                    this.newAuctions.put(event.newAuction.seller, event.newAuction);
                }
            } else {
                for (Auction auction : this.newAuctions.get(event.newPerson.id)) {
                    this.addResult(auction, event.newPerson, timestamp);
                }
                this.newAuctions.removeAll(event.newPerson.id);
                this.newPersons.put(event.newPerson.id, event.newPerson);
            }
        }
    }
}

