/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries.sql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.sql.ToRow;
import org.apache.beam.sdk.nexmark.model.sql.adapter.ModelAdaptersMapping;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;

public class SqlQuery0
extends PTransform<PCollection<Event>, PCollection<Bid>> {
    private static final PTransform<PInput, PCollection<Row>> QUERY = SqlTransform.query((String)"SELECT * FROM PCOLLECTION");

    public SqlQuery0() {
        super("SqlQuery0");
    }

    public PCollection<Bid> expand(PCollection<Event> allEvents) {
        RowCoder bidRowCoder = this.getBidRowCoder();
        PCollection bidEventsRows = ((PCollection)((PCollection)((PCollection)allEvents.apply((PTransform)Filter.by(NexmarkQuery.IS_BID))).apply(this.getName() + ".ToRow", ToRow.parDo())).apply(this.getName() + ".Serialize", this.logBytesMetric(bidRowCoder))).setCoder((Coder)bidRowCoder);
        PCollection queryResultsRows = ((PCollection)bidEventsRows.apply(QUERY)).setCoder((Coder)bidRowCoder);
        return ((PCollection)queryResultsRows.apply(this.bidParDo())).setCoder(Bid.CODER);
    }

    private PTransform<? super PCollection<Row>, PCollection<Row>> logBytesMetric(final RowCoder coder) {
        return ParDo.of((DoFn)new DoFn<Row, Row>(){
            private final Counter bytesMetric;
            {
                this.bytesMetric = Metrics.counter((String)SqlQuery0.this.name, (String)"bytes");
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws CoderException, IOException {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                coder.encode((Object)((Row)c.element()), (OutputStream)outStream, Coder.Context.OUTER);
                byte[] byteArray = outStream.toByteArray();
                this.bytesMetric.inc((long)byteArray.length);
                ByteArrayInputStream inStream = new ByteArrayInputStream(byteArray);
                Row row = (Row)coder.decode((InputStream)inStream, Coder.Context.OUTER);
                c.output((Object)row);
            }
        });
    }

    private RowCoder getBidRowCoder() {
        return ModelAdaptersMapping.ADAPTERS.get(Bid.class).getSchema().getRowCoder();
    }

    private ParDo.SingleOutput<Row, Bid> bidParDo() {
        return ModelAdaptersMapping.ADAPTERS.get(Bid.class).parDo();
    }
}

