/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries.sql;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.sql.ToRow;
import org.apache.beam.sdk.nexmark.model.sql.adapter.ModelAdaptersMapping;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;

public class SqlQuery1
extends PTransform<PCollection<Event>, PCollection<Bid>> {
    private static final PTransform<PInput, PCollection<Row>> QUERY = SqlTransform.query((String)"SELECT auction, bidder, DolToEur(price) as price, dateTime, extra FROM PCOLLECTION").registerUdf("DolToEur", (SerializableFunction)new DolToEur());

    public SqlQuery1() {
        super("SqlQuery1");
    }

    public PCollection<Bid> expand(PCollection<Event> allEvents) {
        RowCoder bidRecordCoder = this.getBidRowCoder();
        PCollection bidEventsRows = ((PCollection)((PCollection)allEvents.apply((PTransform)Filter.by(NexmarkQuery.IS_BID))).apply(this.getName() + ".ToRow", ToRow.parDo())).setCoder((Coder)bidRecordCoder);
        PCollection queryResultsRows = (PCollection)bidEventsRows.apply(QUERY);
        return ((PCollection)queryResultsRows.apply(this.bidParDo())).setCoder(Bid.CODER);
    }

    private RowCoder getBidRowCoder() {
        return ModelAdaptersMapping.ADAPTERS.get(Bid.class).getSchema().getRowCoder();
    }

    private ParDo.SingleOutput<Row, Bid> bidParDo() {
        return ModelAdaptersMapping.ADAPTERS.get(Bid.class).parDo();
    }

    public static class DolToEur
    implements SerializableFunction<Long, Long> {
        public Long apply(Long price) {
            return price * 89L / 100L;
        }
    }
}

