/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries.sql;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.nexmark.model.AuctionPrice;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.sql.ToRow;
import org.apache.beam.sdk.nexmark.model.sql.adapter.ModelAdaptersMapping;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;

public class SqlQuery2
extends PTransform<PCollection<Event>, PCollection<AuctionPrice>> {
    private static final String QUERY_TEMPLATE = "SELECT auction, bidder, price, dateTime, extra  FROM PCOLLECTION  WHERE MOD(auction, %d) = 0";
    private final PTransform<PInput, PCollection<Row>> query;

    public SqlQuery2(long skipFactor) {
        super("SqlQuery2");
        String queryString = String.format(QUERY_TEMPLATE, skipFactor);
        this.query = SqlTransform.query((String)queryString);
    }

    public PCollection<AuctionPrice> expand(PCollection<Event> allEvents) {
        RowCoder bidRecordCoder = this.getBidRowCoder();
        PCollection bidEventsRows = ((PCollection)((PCollection)allEvents.apply((PTransform)Filter.by(NexmarkQuery.IS_BID))).apply(this.getName() + ".ToRow", ToRow.parDo())).setCoder((Coder)bidRecordCoder);
        PCollection queryResultsRows = (PCollection)bidEventsRows.apply(this.query);
        return ((PCollection)queryResultsRows.apply(this.auctionPriceParDo())).setCoder(AuctionPrice.CODER);
    }

    private RowCoder getBidRowCoder() {
        return ModelAdaptersMapping.ADAPTERS.get(Bid.class).getSchema().getRowCoder();
    }

    private ParDo.SingleOutput<Row, AuctionPrice> auctionPriceParDo() {
        return ModelAdaptersMapping.ADAPTERS.get(AuctionPrice.class).parDo();
    }
}

