/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries.sql;

import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.NameCityStateId;
import org.apache.beam.sdk.nexmark.model.Person;
import org.apache.beam.sdk.nexmark.model.sql.ToRow;
import org.apache.beam.sdk.nexmark.model.sql.adapter.ModelAdaptersMapping;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.joda.time.Duration;

public class SqlQuery3
extends PTransform<PCollection<Event>, PCollection<NameCityStateId>> {
    private static final String QUERY_NAME = SqlQuery3.class.getSimpleName();
    private static final String QUERY_STRING = " SELECT     P.name, P.city, P.state, A.id  FROM     Auction A INNER JOIN Person P on A.seller = P.id  WHERE     A.category = 10     AND (P.state = 'OR' OR P.state = 'ID' OR P.state = 'CA')";
    private static final RowCoder RECORD_CODER = SqlQuery3.createRecordCoder();
    private NexmarkConfiguration configuration;

    public SqlQuery3(NexmarkConfiguration configuration) {
        super(QUERY_NAME);
        this.configuration = configuration;
    }

    public PCollection<NameCityStateId> expand(PCollection<Event> allEvents) {
        PCollection<Event> windowed = this.fixedWindows(allEvents);
        PCollection<Row> auctions = this.filter(windowed, (SerializableFunction<Event, Boolean>)(SerializableFunction & Serializable)e -> e.newAuction != null, Auction.class);
        PCollection<Row> people = this.filter(windowed, (SerializableFunction<Event, Boolean>)(SerializableFunction & Serializable)e -> e.newPerson != null, Person.class);
        PCollectionTuple inputStreams = this.createStreamsTuple(auctions, people);
        PCollection queryResultsRows = ((PCollection)inputStreams.apply((PTransform)SqlTransform.query((String)QUERY_STRING))).setCoder((Coder)RECORD_CODER);
        return ((PCollection)queryResultsRows.apply(this.nameCityStateIdParDo())).setCoder(NameCityStateId.CODER);
    }

    private PCollection<Event> fixedWindows(PCollection<Event> events) {
        return (PCollection)events.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)this.configuration.windowSizeSec))));
    }

    private PCollectionTuple createStreamsTuple(PCollection<Row> auctions, PCollection<Row> people) {
        return PCollectionTuple.of((TupleTag)new TupleTag("Auction"), auctions).and(new TupleTag("Person"), people);
    }

    private PCollection<Row> filter(PCollection<Event> allEvents, SerializableFunction<Event, Boolean> filter, Class clazz) {
        String modelName = clazz.getSimpleName();
        return ((PCollection)((PCollection)allEvents.apply(QUERY_NAME + ".Filter." + modelName, (PTransform)Filter.by(filter))).apply(QUERY_NAME + ".ToRecords." + modelName, ToRow.parDo())).setCoder((Coder)this.getRecordCoder(clazz));
    }

    private RowCoder getRecordCoder(Class modelClass) {
        return ModelAdaptersMapping.ADAPTERS.get(modelClass).getSchema().getRowCoder();
    }

    private static RowCoder createRecordCoder() {
        return Schema.builder().addStringField("name").addStringField("city").addStringField("state").addInt64Field("id").build().getRowCoder();
    }

    private ParDo.SingleOutput<Row, NameCityStateId> nameCityStateIdParDo() {
        return ModelAdaptersMapping.ADAPTERS.get(NameCityStateId.class).parDo();
    }
}

