/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.queries.sql;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.model.sql.ToRow;
import org.apache.beam.sdk.nexmark.model.sql.adapter.ModelAdaptersMapping;
import org.apache.beam.sdk.nexmark.queries.NexmarkQuery;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;

public class SqlQuery7
extends PTransform<PCollection<Event>, PCollection<Bid>> {
    private static final String QUERY_TEMPLATE = " SELECT B.auction, B.price, B.bidder, B.dateTime, B.extra     FROM (SELECT B.auction, B.price, B.bidder, B.dateTime, B.extra,        TUMBLE_START(B.dateTime, INTERVAL '%1$d' SECOND) AS starttime     FROM Bid B     GROUP BY B.auction, B.price, B.bidder, B.dateTime, B.extra,        TUMBLE(B.dateTime, INTERVAL '%1$d' SECOND)) B  JOIN (SELECT MAX(B1.price) AS maxprice,        TUMBLE_START(B1.dateTime, INTERVAL '%1$d' SECOND) AS starttime     FROM Bid B1     GROUP BY TUMBLE(B1.dateTime, INTERVAL '%1$d' SECOND)) B1  ON B.starttime = B1.starttime AND B.price = B1.maxprice ";
    private final PTransform<PInput, PCollection<Row>> query;

    public SqlQuery7(NexmarkConfiguration configuration) {
        super("SqlQuery7");
        String queryString = String.format(QUERY_TEMPLATE, configuration.windowSizeSec);
        this.query = SqlTransform.query((String)queryString);
    }

    public PCollection<Bid> expand(PCollection<Event> allEvents) {
        RowCoder bidRecordCoder = this.getBidRowCoder();
        PCollection bids = ((PCollection)((PCollection)allEvents.apply((PTransform)Filter.by(NexmarkQuery.IS_BID))).apply(this.getName() + ".ToRow", ToRow.parDo())).setCoder((Coder)bidRecordCoder);
        PCollection queryResultsRows = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("Bid"), (PCollection)bids).apply(this.query);
        return ((PCollection)queryResultsRows.apply(this.bidParDo())).setCoder(Bid.CODER);
    }

    private RowCoder getBidRowCoder() {
        return ModelAdaptersMapping.ADAPTERS.get(Bid.class).getSchema().getRowCoder();
    }

    private ParDo.SingleOutput<Row, Bid> bidParDo() {
        return ModelAdaptersMapping.ADAPTERS.get(Bid.class).parDo();
    }
}

