/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.sources.generator;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.Preconditions;
import org.apache.beam.sdk.nexmark.model.Event;
import org.apache.beam.sdk.nexmark.sources.generator.GeneratorCheckpoint;
import org.apache.beam.sdk.nexmark.sources.generator.GeneratorConfig;
import org.apache.beam.sdk.nexmark.sources.generator.model.AuctionGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.BidGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.PersonGenerator;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Instant;

public class Generator
implements Iterator<TimestampedValue<Event>>,
Serializable {
    private GeneratorConfig config;
    private long eventsCountSoFar;
    private long wallclockBaseTime;

    Generator(GeneratorConfig config, long eventsCountSoFar, long wallclockBaseTime) {
        Preconditions.checkNotNull(config);
        this.config = config;
        this.eventsCountSoFar = eventsCountSoFar;
        this.wallclockBaseTime = wallclockBaseTime;
    }

    public Generator(GeneratorConfig config) {
        this(config, 0L, -1L);
    }

    public GeneratorCheckpoint toCheckpoint() {
        return new GeneratorCheckpoint(this.eventsCountSoFar, this.wallclockBaseTime);
    }

    public Generator copy() {
        Preconditions.checkNotNull(this.config);
        Generator result = new Generator(this.config, this.eventsCountSoFar, this.wallclockBaseTime);
        return result;
    }

    public GeneratorConfig getCurrentConfig() {
        return this.config;
    }

    public GeneratorConfig splitAtEventId(long eventId) {
        long newMaxEvents = eventId - (this.config.firstEventId + this.config.firstEventNumber);
        GeneratorConfig remainConfig = this.config.copyWith(this.config.firstEventId, this.config.maxEvents - newMaxEvents, this.config.firstEventNumber + newMaxEvents);
        this.config = this.config.copyWith(this.config.firstEventId, newMaxEvents, this.config.firstEventNumber);
        return remainConfig;
    }

    public long getNextEventId() {
        return this.config.firstEventId + this.config.nextAdjustedEventNumber(this.eventsCountSoFar);
    }

    @Override
    public boolean hasNext() {
        return this.eventsCountSoFar < this.config.maxEvents;
    }

    public NextEvent nextEvent() {
        if (this.wallclockBaseTime < 0L) {
            this.wallclockBaseTime = System.currentTimeMillis();
        }
        long eventTimestamp = (Long)this.config.timestampAndInterEventDelayUsForEvent(this.config.nextEventNumber(this.eventsCountSoFar)).getKey();
        long adjustedEventTimestamp = (Long)this.config.timestampAndInterEventDelayUsForEvent(this.config.nextAdjustedEventNumber(this.eventsCountSoFar)).getKey();
        long watermark = (Long)this.config.timestampAndInterEventDelayUsForEvent(this.config.nextEventNumberForWatermark(this.eventsCountSoFar)).getKey();
        long wallclockTimestamp = this.wallclockBaseTime + (eventTimestamp - this.getCurrentConfig().baseTime);
        Random random = new Random(this.getNextEventId());
        long newEventId = this.getNextEventId();
        long rem = newEventId % 50L;
        Event event = rem < 1L ? new Event(PersonGenerator.nextPerson(newEventId, random, adjustedEventTimestamp, this.config)) : (rem < 4L ? new Event(AuctionGenerator.nextAuction(this.eventsCountSoFar, newEventId, random, adjustedEventTimestamp, this.config)) : new Event(BidGenerator.nextBid(newEventId, random, adjustedEventTimestamp, this.config)));
        ++this.eventsCountSoFar;
        return new NextEvent(wallclockTimestamp, adjustedEventTimestamp, event, watermark);
    }

    @Override
    public TimestampedValue<Event> next() {
        NextEvent next = this.nextEvent();
        return TimestampedValue.of((Object)next.event, (Instant)new Instant(next.eventTimestamp));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long currentInterEventDelayUs() {
        return (Long)this.config.timestampAndInterEventDelayUsForEvent(this.config.nextEventNumber(this.eventsCountSoFar)).getValue();
    }

    public double getFractionConsumed() {
        return (double)this.eventsCountSoFar / (double)this.config.maxEvents;
    }

    public String toString() {
        return String.format("Generator{config:%s; eventsCountSoFar:%d; wallclockBaseTime:%d}", this.config, this.eventsCountSoFar, this.wallclockBaseTime);
    }

    public static class NextEvent
    implements Comparable<NextEvent> {
        public final long wallclockTimestamp;
        public final long eventTimestamp;
        public final Event event;
        public final long watermark;

        public NextEvent(long wallclockTimestamp, long eventTimestamp, Event event, long watermark) {
            this.wallclockTimestamp = wallclockTimestamp;
            this.eventTimestamp = eventTimestamp;
            this.event = event;
            this.watermark = watermark;
        }

        public NextEvent withDelay(long delayMs) {
            return new NextEvent(this.wallclockTimestamp + delayMs, this.eventTimestamp, this.event.withAnnotation("LATE"), this.watermark);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NextEvent nextEvent = (NextEvent)o;
            return this.wallclockTimestamp == nextEvent.wallclockTimestamp && this.eventTimestamp == nextEvent.eventTimestamp && this.watermark == nextEvent.watermark && this.event.equals(nextEvent.event);
        }

        public int hashCode() {
            return Objects.hash(this.wallclockTimestamp, this.eventTimestamp, this.watermark, this.event);
        }

        @Override
        public int compareTo(NextEvent other) {
            int i = Long.compare(this.wallclockTimestamp, other.wallclockTimestamp);
            if (i != 0) {
                return i;
            }
            return Integer.compare(this.event.hashCode(), other.event.hashCode());
        }
    }
}

