/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.sources.generator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.repackaged.beam_sdks_java_nexmark.com.google.common.base.MoreObjects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.nexmark.sources.generator.Generator;
import org.apache.beam.sdk.nexmark.sources.generator.GeneratorConfig;

public class GeneratorCheckpoint
implements UnboundedSource.CheckpointMark {
    private static final Coder<Long> LONG_CODER = VarLongCoder.of();
    public static final Coder<GeneratorCheckpoint> CODER_INSTANCE = new CustomCoder<GeneratorCheckpoint>(){

        public void encode(GeneratorCheckpoint value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode((Object)value.numEvents, outStream);
            LONG_CODER.encode((Object)value.wallclockBaseTime, outStream);
        }

        public GeneratorCheckpoint decode(InputStream inStream) throws CoderException, IOException {
            long numEvents = (Long)LONG_CODER.decode(inStream);
            long wallclockBaseTime = (Long)LONG_CODER.decode(inStream);
            return new GeneratorCheckpoint(numEvents, wallclockBaseTime);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    };
    private final long numEvents;
    private final long wallclockBaseTime;

    GeneratorCheckpoint(long numEvents, long wallclockBaseTime) {
        this.numEvents = numEvents;
        this.wallclockBaseTime = wallclockBaseTime;
    }

    public Generator toGenerator(GeneratorConfig config) {
        return new Generator(config, this.numEvents, this.wallclockBaseTime);
    }

    public void finalizeCheckpoint() throws IOException {
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("numEvents", this.numEvents).add("wallclockBaseTime", this.wallclockBaseTime).toString();
    }
}

