/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.sources.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.nexmark.NexmarkConfiguration;
import org.apache.beam.sdk.values.KV;

public class GeneratorConfig
implements Serializable {
    public static final long FIRST_AUCTION_ID = 1000L;
    public static final long FIRST_PERSON_ID = 1000L;
    public static final long FIRST_CATEGORY_ID = 10L;
    public static final int PERSON_PROPORTION = 1;
    public static final int AUCTION_PROPORTION = 3;
    private static final int BID_PROPORTION = 46;
    public static final int PROPORTION_DENOMINATOR = 50;
    private final NexmarkConfiguration configuration;
    private final long[] interEventDelayUs;
    private final long stepLengthSec;
    public final long baseTime;
    public final long firstEventId;
    public final long maxEvents;
    public final long firstEventNumber;
    private final long epochPeriodMs;
    private final long eventsPerEpoch;

    public GeneratorConfig(NexmarkConfiguration configuration, long baseTime, long firstEventId, long maxEventsOrZero, long firstEventNumber) {
        this.configuration = configuration;
        this.interEventDelayUs = configuration.rateShape.interEventDelayUs(configuration.firstEventRate, configuration.nextEventRate, configuration.rateUnit, configuration.numEventGenerators);
        this.stepLengthSec = configuration.rateShape.stepLengthSec(configuration.ratePeriodSec);
        this.baseTime = baseTime;
        this.firstEventId = firstEventId;
        this.maxEvents = maxEventsOrZero == 0L ? Long.MAX_VALUE / (long)(50 * Math.max(Math.max(configuration.avgPersonByteSize, configuration.avgAuctionByteSize), configuration.avgBidByteSize)) : maxEventsOrZero;
        this.firstEventNumber = firstEventNumber;
        long eventsPerEpoch = 0L;
        long epochPeriodMs = 0L;
        if (this.interEventDelayUs.length > 1) {
            for (long interEventDelayU : this.interEventDelayUs) {
                long numEventsForThisCycle = this.stepLengthSec * 1000000L / interEventDelayU;
                eventsPerEpoch += numEventsForThisCycle;
                epochPeriodMs += numEventsForThisCycle * interEventDelayU / 1000L;
            }
        }
        this.eventsPerEpoch = eventsPerEpoch;
        this.epochPeriodMs = epochPeriodMs;
    }

    public GeneratorConfig copy() {
        GeneratorConfig result = new GeneratorConfig(this.configuration, this.baseTime, this.firstEventId, this.maxEvents, this.firstEventNumber);
        return result;
    }

    public List<GeneratorConfig> split(int n) {
        ArrayList<GeneratorConfig> results = new ArrayList<GeneratorConfig>();
        if (n == 1) {
            results.add(this);
        } else {
            long subMaxEvents = this.maxEvents / (long)n;
            long subFirstEventId = this.firstEventId;
            for (int i = 0; i < n; ++i) {
                if (i == n - 1) {
                    subMaxEvents = this.maxEvents - subMaxEvents * (long)(n - 1);
                }
                results.add(this.copyWith(subFirstEventId, subMaxEvents, this.firstEventNumber));
                subFirstEventId += subMaxEvents;
            }
        }
        return results;
    }

    public GeneratorConfig copyWith(long firstEventId, long maxEvents, long firstEventNumber) {
        return new GeneratorConfig(this.configuration, this.baseTime, firstEventId, maxEvents, firstEventNumber);
    }

    public long estimatedBytesForEvents(long numEvents) {
        long numPersons = numEvents * 1L / 50L;
        long numAuctions = numEvents * 3L / 50L;
        long numBids = numEvents * 46L / 50L;
        return numPersons * (long)this.configuration.avgPersonByteSize + numAuctions * (long)this.configuration.avgAuctionByteSize + numBids * (long)this.configuration.avgBidByteSize;
    }

    public int getAvgPersonByteSize() {
        return this.configuration.avgPersonByteSize;
    }

    public int getNumActivePeople() {
        return this.configuration.numActivePeople;
    }

    public int getHotSellersRatio() {
        return this.configuration.hotSellersRatio;
    }

    public int getNumInFlightAuctions() {
        return this.configuration.numInFlightAuctions;
    }

    public int getHotAuctionRatio() {
        return this.configuration.hotAuctionRatio;
    }

    public int getHotBiddersRatio() {
        return this.configuration.hotBiddersRatio;
    }

    public int getAvgBidByteSize() {
        return this.configuration.avgBidByteSize;
    }

    public int getAvgAuctionByteSize() {
        return this.configuration.avgAuctionByteSize;
    }

    public double getProbDelayedEvent() {
        return this.configuration.probDelayedEvent;
    }

    public long getOccasionalDelaySec() {
        return this.configuration.occasionalDelaySec;
    }

    public long getEstimatedSizeBytes() {
        return this.estimatedBytesForEvents(this.maxEvents);
    }

    public long getStartEventId() {
        return this.firstEventId + this.firstEventNumber;
    }

    public long getStopEventId() {
        return this.firstEventId + this.firstEventNumber + this.maxEvents;
    }

    public long nextEventNumber(long numEvents) {
        return this.firstEventNumber + numEvents;
    }

    public long nextAdjustedEventNumber(long numEvents) {
        long n = this.configuration.outOfOrderGroupSize;
        long eventNumber = this.nextEventNumber(numEvents);
        long base = eventNumber / n * n;
        long offset = eventNumber * 953L % n;
        return base + offset;
    }

    public long nextEventNumberForWatermark(long numEvents) {
        long n = this.configuration.outOfOrderGroupSize;
        long eventNumber = this.nextEventNumber(numEvents);
        return eventNumber / n * n;
    }

    public KV<Long, Long> timestampAndInterEventDelayUsForEvent(long eventNumber) {
        if (this.interEventDelayUs.length == 1) {
            long timestamp = this.baseTime + eventNumber * this.interEventDelayUs[0] / 1000L;
            return KV.of((Object)timestamp, (Object)this.interEventDelayUs[0]);
        }
        long epoch = eventNumber / this.eventsPerEpoch;
        long n = eventNumber % this.eventsPerEpoch;
        long offsetInEpochMs = 0L;
        for (long interEventDelayU : this.interEventDelayUs) {
            long numEventsForThisCycle = this.stepLengthSec * 1000000L / interEventDelayU;
            if (n < numEventsForThisCycle) {
                long offsetInCycleUs = n * interEventDelayU;
                long timestamp = this.baseTime + epoch * this.epochPeriodMs + offsetInEpochMs + offsetInCycleUs / 1000L;
                return KV.of((Object)timestamp, (Object)interEventDelayU);
            }
            n -= numEventsForThisCycle;
            offsetInEpochMs += numEventsForThisCycle * interEventDelayU / 1000L;
        }
        throw new RuntimeException("internal eventsPerEpoch incorrect");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GeneratorConfig");
        sb.append("{configuration:");
        sb.append(this.configuration.toString());
        sb.append(";interEventDelayUs=[");
        for (int i = 0; i < this.interEventDelayUs.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.interEventDelayUs[i]);
        }
        sb.append("]");
        sb.append(";stepLengthSec:");
        sb.append(this.stepLengthSec);
        sb.append(";baseTime:");
        sb.append(this.baseTime);
        sb.append(";firstEventId:");
        sb.append(this.firstEventId);
        sb.append(";maxEvents:");
        sb.append(this.maxEvents);
        sb.append(";firstEventNumber:");
        sb.append(this.firstEventNumber);
        sb.append(";epochPeriodMs:");
        sb.append(this.epochPeriodMs);
        sb.append(";eventsPerEpoch:");
        sb.append(this.eventsPerEpoch);
        sb.append("}");
        return sb.toString();
    }
}

