/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.sources.generator.model;

import java.util.Random;
import org.apache.beam.sdk.nexmark.model.Auction;
import org.apache.beam.sdk.nexmark.sources.generator.GeneratorConfig;
import org.apache.beam.sdk.nexmark.sources.generator.model.LongGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.PersonGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.PriceGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.StringsGenerator;

public class AuctionGenerator {
    private static final int NUM_CATEGORIES = 5;
    private static final int AUCTION_ID_LEAD = 10;
    private static final int HOT_SELLER_RATIO = 100;

    public static Auction nextAuction(long eventsCountSoFar, long eventId, Random random, long timestamp, GeneratorConfig config) {
        long id = AuctionGenerator.lastBase0AuctionId(eventId) + 1000L;
        long seller = random.nextInt(config.getHotSellersRatio()) > 0 ? PersonGenerator.lastBase0PersonId(eventId) / 100L * 100L : PersonGenerator.nextBase0PersonId(eventId, random, config);
        seller += 1000L;
        long category = 10L + (long)random.nextInt(5);
        long initialBid = PriceGenerator.nextPrice(random);
        long expires = timestamp + AuctionGenerator.nextAuctionLengthMs(eventsCountSoFar, random, timestamp, config);
        String name = StringsGenerator.nextString(random, 20);
        String desc = StringsGenerator.nextString(random, 100);
        long reserve = initialBid + PriceGenerator.nextPrice(random);
        int currentSize = 8 + name.length() + desc.length() + 8 + 8 + 8 + 8 + 8;
        String extra = StringsGenerator.nextExtra(random, currentSize, config.getAvgAuctionByteSize());
        return new Auction(id, name, desc, initialBid, reserve, timestamp, expires, seller, category, extra);
    }

    public static long lastBase0AuctionId(long eventId) {
        long epoch = eventId / 50L;
        long offset = eventId % 50L;
        if (offset < 1L) {
            --epoch;
            offset = 2L;
        } else {
            offset = offset >= 4L ? 2L : --offset;
        }
        return epoch * 3L + offset;
    }

    public static long nextBase0AuctionId(long nextEventId, Random random, GeneratorConfig config) {
        long minAuction = Math.max(AuctionGenerator.lastBase0AuctionId(nextEventId) - (long)config.getNumInFlightAuctions(), 0L);
        long maxAuction = AuctionGenerator.lastBase0AuctionId(nextEventId);
        return minAuction + LongGenerator.nextLong(random, maxAuction - minAuction + 1L + 10L);
    }

    private static long nextAuctionLengthMs(long eventsCountSoFar, Random random, long timestamp, GeneratorConfig config) {
        long currentEventNumber = config.nextAdjustedEventNumber(eventsCountSoFar);
        long numEventsForAuctions = (long)config.getNumInFlightAuctions() * 50L / 3L;
        long futureAuction = (Long)config.timestampAndInterEventDelayUsForEvent(currentEventNumber + numEventsForAuctions).getKey();
        long horizonMs = futureAuction - timestamp;
        return 1L + LongGenerator.nextLong(random, Math.max(horizonMs * 2L, 1L));
    }
}

